/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.old.ominbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.algorithm.TaxAlgorithmForBotp;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.InvBillConst;

public class OmInBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        InvBillConst.getSelectorListForAcc().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("stockindate");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("materialmasterid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> importData = new ArrayList<DynamicObject>(16);
        DynamicObject[] dataEntities = e.getDataEntities();
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("lastupdateuser", (Object)UserServiceHelper.getCurrentUser((String)"id"));
            dataEntity.set("lastupdatetime", (Object)new Date());
            String billCreType = dataEntity.getString("billcretype");
            if (!"1".equals(billCreType) && !"3".equals(billCreType)) continue;
            importData.add(dataEntity);
        }
        if (importData.isEmpty()) {
            return;
        }
        for (DynamicObject bill : importData) {
            TaxAlgorithmForBotp algo = new TaxAlgorithmForBotp(bill);
            algo.reCalFields();
            DynamicObjectCollection enrtyList = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : enrtyList) {
                BigDecimal amount = entry.getBigDecimal("amount");
                boolean flag = this.checkBigDecimal(amount);
                if (flag) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u8d85\u8fc7\u7cfb\u7edf\u9884\u5236\u6700\u5927\u503c\u201c9999999999999\u201d\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u76f8\u5173\u6570\u636e\u3002", (String)"OmInBillSaveOp_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkBigDecimal(BigDecimal amount) {
        return amount.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) <= 0;
    }
}

