/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.old.ominbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.common.mdc.consts.OMOldVerifyConsts;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OmInBillWriteOffOp
extends AbstractOperationServicePlugIn {
    private static final String ENTITY_OMINBILL = "im_mdc_ominbill";
    private static final Log logger = LogFactory.getLog(OmInBillWriteOffOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("manubill");
        e.getFieldKeys().add("manubillid");
        e.getFieldKeys().add("manuentry");
        e.getFieldKeys().add("manuentryid");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add("qualitystatus");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("receivalqty");
        e.getFieldKeys().add("receivedqty");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("productionorg");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("billentry.manuentryid");
        e.getFieldKeys().add("billentry.manubillid");
        e.getFieldKeys().addAll(OMOldVerifyConsts.allVerifyFields);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info((Object)"\u7b80\u5355\u59d4\u5916\u7ea2\u84dd\u5e94\u4ed8\u6838\u9500\u5f00\u59cb\u8bbe\u7f6e\u53cd\u5199\u5b57\u6bb5");
        DynamicObject[] bills = e.getDataEntities();
        this.setRwFields(bills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        logger.info((Object)"\u7b80\u5355\u59d4\u5916\u7ea2\u84dd\u5e94\u4ed8\u6838\u9500\u5f00\u59cb");
        DynamicObject[] curBills = e.getDataEntities();
        if (curBills == null || curBills.length == 0) {
            return;
        }
        this.autoVerify(curBills);
    }

    private void setRwFields(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entryList) {
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                BigDecimal qty = entry.getBigDecimal("qty");
                entry.set("returnbaseqty", (Object)BigDecimal.ZERO);
                entry.set("returnqty", (Object)BigDecimal.ZERO);
                BigDecimal returnQty = entry.getBigDecimal("returnqty");
                entry.set("remainreturnqty", (Object)qty.subtract(returnQty));
                BigDecimal returnBaseQty = entry.getBigDecimal("returnbaseqty");
                entry.set("remainreturnbaseqty", (Object)baseQty.subtract(returnBaseQty));
                entry.set("joinpriceqty", (Object)BigDecimal.ZERO);
                BigDecimal joinPriceQty = entry.getBigDecimal("joinpriceqty");
                entry.set("remainjoinpriceqty", (Object)qty.subtract(joinPriceQty));
                entry.set("joinpricebaseqty", (Object)BigDecimal.ZERO);
                BigDecimal joinPriceBaseQty = entry.getBigDecimal("joinpricebaseqty");
                entry.set("remainjoinpricebaseqty", (Object)baseQty.subtract(joinPriceBaseQty));
                entry.set("verifyqty", (Object)BigDecimal.ZERO);
                BigDecimal verifyQty = entry.getBigDecimal("verifyqty");
                entry.set("unverifyqty", (Object)qty.subtract(verifyQty));
                entry.set("verifybaseqty", (Object)BigDecimal.ZERO);
                BigDecimal verifyBaseQty = entry.getBigDecimal("verifybaseqty");
                entry.set("unverifybaseqty", (Object)baseQty.subtract(verifyBaseQty));
            }
        }
    }

    private void autoVerify(DynamicObject[] curBills) {
        logger.info((Object)"\u5224\u65ad\u662f\u5426\u542f\u7528AP\u5e94\u7528\uff0c\u662f\u5426\u8c03\u7528\u59d4\u5916\u5e94\u4ed8\u6838\u9500\u63a5\u53e3");
        if (!MetaDataHelper.isBizAppExistAp()) {
            return;
        }
        Long[] curBillPksParam = new Long[curBills.length];
        ArrayList<DynamicObject> autoVerifyList = new ArrayList<DynamicObject>(curBills.length);
        for (int i = 0; i < curBills.length; ++i) {
            curBillPksParam[i] = (Long)curBills[i].getPkValue();
            autoVerifyList.add(curBills[i]);
        }
        Map sourceBillPkMap = BFTrackerServiceHelper.findSourceBills((String)ENTITY_OMINBILL, (Long[])curBillPksParam);
        Set sourcePurBillPks = (Set)sourceBillPkMap.get(ENTITY_OMINBILL);
        if (sourcePurBillPks != null) {
            QFilter qf = new QFilter("id", "in", (Object)sourcePurBillPks);
            DynamicObject[] sourceBillObject = BusinessDataServiceHelper.load((String)ENTITY_OMINBILL, (String)String.join((CharSequence)",", OMOldVerifyConsts.verifyFields), (QFilter[])qf.toArray());
            boolean isAllEntryEmpty = true;
            for (DynamicObject bill : sourceBillObject) {
                DynamicObjectCollection entryList = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entryList) {
                    BigDecimal unVerifyQty = entry.getBigDecimal("unverifyqty");
                    if (unVerifyQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    isAllEntryEmpty = false;
                }
            }
            if (!isAllEntryEmpty) {
                logger.info((Object)" OmInBillWriteOffOp\u8c03\u7528AP\uff0cominself AutoVerify\u63a5\u53e3");
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ominself", (String)"autoVerify", (Object[])new Object[]{sourceBillObject, autoVerifyList.toArray(new DynamicObject[autoVerifyList.size()])});
                logger.info((Object)"OmInBillWriteOffOp\u8c03\u7528AP\uff0cominself AutoVerify\u63a5\u53e3\u5b8c\u6bd5");
            }
        }
    }
}

