/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scmc.im.common.mdc.helper.OmOrderBookDateHelper;
import kd.scmc.im.common.mdc.utils.OMStockBackFlushUtils;
import kd.scmc.im.common.mdc.utils.ProCalMaterialUtils;
import kd.scmc.im.opplugin.mdc.mftmanuinbill.MftOrderCalWriteUtils;
import org.apache.commons.collections.CollectionUtils;

public class OmCmplInBillAuditOrUnauditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OmCmplInBillAuditOrUnauditOp.class);
    private static final String KEY_BILLENTRY = "billentry";
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("manuentryid");
        e.getFieldKeys().add("manubillid");
        e.getFieldKeys().add("modeltype");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("billentry.id");
        e.getFieldKeys().add("billentry.backflushstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataArray = e.getDataEntities();
        if (UNAUDIT.equals(e.getOperationKey())) {
            for (DynamicObject dataEntity : dataArray) {
                DynamicObjectCollection coll = dataEntity.getDynamicObjectCollection(KEY_BILLENTRY);
                coll.forEach(a -> a.set("backflushstatus", (Object)"D"));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        List selectedRows = e.getSelectedRows();
        if (!AUDIT.equals(operationKey) && !UNAUDIT.equals(operationKey)) {
            return;
        }
        HashSet<Long> mftIdList = new HashSet<Long>(selectedRows.size());
        HashSet<String> orderIds = new HashSet<String>(16);
        ArrayList<Long> orderEntryIdList = new ArrayList<Long>(selectedRows.size());
        HashSet<String> orderEntryIds = new HashSet<String>(16);
        Map<Object, DynamicObject> billMap = OmCmplInBillAuditOrUnauditOp.getMftManuMap(selectedRows);
        for (ExtendedDataEntity objEntity : selectedRows) {
            DynamicObject bill = billMap.get(objEntity.getBillPkId());
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection(KEY_BILLENTRY);
            if ("B".equals(bill.getString("modeltype"))) continue;
            for (DynamicObject entryObj : billEntry) {
                mftIdList.add(entryObj.getLong("manubillid"));
                orderEntryIdList.add(entryObj.getLong("manuentryid"));
                orderEntryIds.add(entryObj.getString("manuentryId"));
                orderIds.add(entryObj.getString("manubillid"));
            }
        }
        if (CollectionUtils.isNotEmpty(orderEntryIdList)) {
            this.aculUseQtyByOrderEntryId(orderEntryIdList);
        }
        if (CollectionUtils.isNotEmpty(mftIdList)) {
            MftOrderCalWriteUtils.updateMftEndworktime(mftIdList, "om_mftorder");
        }
        if (!orderEntryIds.isEmpty() && AUDIT.equals(operationKey)) {
            Set<String> resultEntryidSet = ProCalMaterialUtils.getMftOrderEntryids(orderIds, orderEntryIds, "om_mftorder");
            logger.info("\u5f00\u59cb\u8c03\u7528\uff1a\u8ba1\u7b97\u9886\u6599\u5957\u6570 \u4e8b\u4ef6\u4e2d\u5fc3:auditCalMaterial");
            this.autoAculUseAndCloseOrder(operationKey, resultEntryidSet, orderIds);
        }
        DynamicObject[] dObjects = e.getDataEntities();
        if (AUDIT.equals(operationKey)) {
            this.auditCmplInBill(dObjects);
        }
        if (AUDIT.equals(e.getOperationKey())) {
            ArrayList<Object> orderReportBillEntryIds = new ArrayList<Object>(16);
            for (DynamicObject dataEntity : e.getDataEntities()) {
                DynamicObjectCollection coll = dataEntity.getDynamicObjectCollection(KEY_BILLENTRY);
                coll.forEach(a -> orderReportBillEntryIds.add(a.getLong("id")));
            }
            if (!orderReportBillEntryIds.isEmpty()) {
                OMStockBackFlushUtils.updateBFStatusByEntryId(orderReportBillEntryIds, this.billEntityType.getName());
            }
        }
    }

    public static Map<Object, DynamicObject> getMftManuMap(List<ExtendedDataEntity> selectedRows) {
        String entityName = "im_mdc_omcmplinbill";
        ArrayList<Object> idList = new ArrayList<Object>(selectedRows.size());
        for (ExtendedDataEntity objEntity : selectedRows) {
            idList.add(objEntity.getBillPkId());
            entityName = objEntity.getDataEntity().getDataEntityType().getName();
        }
        String selects = "modeltype,billentry,billentry.manuentryid,billentry.manubillid";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", idList)};
        DynamicObject[] load = BusinessDataServiceHelper.load((String)entityName, (String)selects, (QFilter[])qFilters);
        HashMap<Object, DynamicObject> billMap = new HashMap<Object, DynamicObject>(load.length);
        for (DynamicObject dym : load) {
            billMap.put(dym.getPkValue(), dym);
        }
        return billMap;
    }

    private void autoAculUseAndCloseOrder(String operationKey, Set<String> orderEntryids, Set<String> orderids) {
        HashMap<String, Object> calparam = new HashMap<String, Object>(8);
        calparam.put("orderentryids", orderEntryids);
        calparam.put("orderids", orderids);
        calparam.put("operate", operationKey);
        calparam.put("iscloseorder", "1");
        calparam.put("isautocal", "0");
        calparam.put("isautoflag", "0");
        calparam.put("modetype", "2");
        calparam.put("appId", "im");
        String jsonString = JSON.toJSONString(calparam);
        EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
    }

    private void aculUseQtyByOrderEntryId(List<Long> orderEntryIdList) {
        logger.info("\u5f00\u59cb\u8c03\u7528\uff1a\u6279\u91cf\u8ba1\u7b97\u5df2\u6d88\u8017\u6570\u91cf\u670d\u52a1 bd-mpdm IMftOrderService batchCulUseQtyByOrderEntryId");
        try {
            DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMftOrderService", (String)"batchCulUseQtyByOrderEntryId", (Object[])new Object[]{orderEntryIdList, "om_mftorder"});
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u6279\u91cf\u8ba1\u7b97\u5df2\u6d88\u8017\u6570\u91cf\u670d\u52a1\u5931\u8d25", (Throwable)ex);
            throw new KDException((Throwable)ex, new ErrorCode("IMftOrderService", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
        }
        logger.info("\u8c03\u7528\u7ed3\u675f\uff1a\u6279\u91cf\u8ba1\u7b97\u5df2\u6d88\u8017\u6570\u91cf\u670d\u52a1 bd-mpdm IMftOrderService batchCulUseQtyByOrderEntryId");
    }

    private void auditCmplInBill(DynamicObject[] billObjs) {
        OmOrderBookDateHelper helper;
        if (billObjs.length <= 0) {
            return;
        }
        ArrayList<DynamicObject> recBillLst = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> cmpLInBillLst = new ArrayList<DynamicObject>(16);
        for (DynamicObject billObj : billObjs) {
            String biztypeNumber;
            DynamicObject biztypeObj = billObj.getDynamicObject("biztype");
            String string = biztypeNumber = biztypeObj != null ? biztypeObj.getString("number") : "";
            if (StringUtils.equalsIgnoreCase((CharSequence)"604", (CharSequence)biztypeNumber)) {
                recBillLst.add(billObj);
                continue;
            }
            cmpLInBillLst.add(billObj);
        }
        if (recBillLst.size() > 0) {
            helper = new OmOrderBookDateHelper(billObjs, "pom_mftorder", KEY_BILLENTRY, "manubillid", "manuentryid");
            helper.updateOrderBookDateByBizBill();
        }
        if (cmpLInBillLst.size() > 0) {
            helper = new OmOrderBookDateHelper(billObjs, "om_mftorder", KEY_BILLENTRY, "manubillid", "manuentryid");
            helper.updateOrderBookDateByBizBill();
        }
    }
}

