/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bd.sbd.consts.BizTypeConsts;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.opplugin.mdc.ommanuinbill.validate.OMLotNumSaveValidator;
import kd.scmc.im.opplugin.mdc.ommanuinbill.validate.OMSerialNumberSaveValidator;
import kd.scmc.im.validator.tpl.LotNumSaveValidator;
import kd.scmc.im.validator.tpl.SerialNumberSaveValidator;

public class OmInBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("ispresent");
        e.getFieldKeys().add("price");
        e.getFieldKeys().add("remainreturnqty");
        e.getFieldKeys().add("remainreturnbaseqty");
        e.getFieldKeys().add("remainjoinpriceqty");
        e.getFieldKeys().add("remainjoinpricebaseqty");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("joinpriceqty");
        e.getFieldKeys().add("joinpricebaseqty");
        e.getFieldKeys().add("verifyqty");
        e.getFieldKeys().add("verifybaseqty");
        e.getFieldKeys().add("unverifyqty");
        e.getFieldKeys().add("unverifybaseqty");
        e.getFieldKeys().add("vmisettleqty");
        e.getFieldKeys().add("vmisettlebaseqty");
        e.getFieldKeys().add("vmiremainsettleqty");
        e.getFieldKeys().add("vmiremainsettlebaseqty");
        e.getFieldKeys().add("billentry.producedept");
        e.getFieldKeys().add("billentry.ecostcenter");
        e.getFieldKeys().add("modeltype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"OmInBillSubmitOp", (String)"beginOperationTransaction");){
            DynamicObject[] bills;
            super.beginOperationTransaction(e);
            for (DynamicObject bill : bills = e.getDataEntities()) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    BigDecimal baseQty = entry.getBigDecimal("baseqty");
                    BigDecimal qty = entry.getBigDecimal("qty");
                    entry.set("returnbaseqty", (Object)BigDecimal.ZERO);
                    entry.set("returnqty", (Object)BigDecimal.ZERO);
                    BigDecimal returnQty = entry.getBigDecimal("returnqty");
                    entry.set("remainreturnqty", (Object)qty.subtract(returnQty));
                    BigDecimal returnBaseQty = entry.getBigDecimal("returnbaseqty");
                    entry.set("remainreturnbaseqty", (Object)baseQty.subtract(returnBaseQty));
                    entry.set("joinpriceqty", (Object)BigDecimal.ZERO);
                    BigDecimal joinPriceQty = entry.getBigDecimal("joinpriceqty");
                    entry.set("remainjoinpriceqty", (Object)qty.subtract(joinPriceQty));
                    entry.set("joinpricebaseqty", (Object)BigDecimal.ZERO);
                    BigDecimal joinPriceBaseQty = entry.getBigDecimal("joinpricebaseqty");
                    entry.set("remainjoinpricebaseqty", (Object)baseQty.subtract(joinPriceBaseQty));
                    entry.set("verifyqty", (Object)BigDecimal.ZERO);
                    BigDecimal verifyQty = entry.getBigDecimal("verifyqty");
                    entry.set("unverifyqty", (Object)qty.subtract(verifyQty));
                    entry.set("verifybaseqty", (Object)BigDecimal.ZERO);
                    BigDecimal verifyBaseQty = entry.getBigDecimal("verifybaseqty");
                    entry.set("unverifybaseqty", (Object)baseQty.subtract(verifyBaseQty));
                    DynamicObject bizType = bill.getDynamicObject("biztype");
                    if (!BizTypeConsts.BIZTYPE_PURINRETURN_VMI.equals(bizType.getPkValue()) && !BizTypeConsts.BIZTYPE_PURIN_VMI.equals(bizType.getPkValue())) continue;
                    entry.set("vmisettleqty", (Object)BigDecimal.ZERO);
                    BigDecimal vmiSettleQty = entry.getBigDecimal("vmisettleqty");
                    entry.set("vmiremainsettleqty", (Object)qty.subtract(vmiSettleQty));
                    entry.set("vmisettleqty", (Object)BigDecimal.ZERO);
                    BigDecimal vmiSettleBaseQty = entry.getBigDecimal("vmisettleqty");
                    entry.set("vmiremainsettlebaseqty", (Object)baseQty.subtract(vmiSettleBaseQty));
                }
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        Iterator iterator = e.getValidators().iterator();
        while (iterator.hasNext()) {
            AbstractValidator validator = (AbstractValidator)iterator.next();
            if (validator instanceof LotNumSaveValidator) {
                iterator.remove();
                continue;
            }
            if (!(validator instanceof SerialNumberSaveValidator)) continue;
            iterator.remove();
        }
        e.getValidators().add(new OMLotNumSaveValidator());
        e.getValidators().add(new OMSerialNumberSaveValidator());
    }
}

