/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill.validate;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;

public class OmCmplInBillValidator
extends AbstractValidator {
    private static final String BIZ_TYPE = "990500657985463296";

    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "audit": {
                HashSet<Long> manuBillIds = new HashSet<Long>(16);
                HashSet<Long> manuEntryIds = new HashSet<Long>(16);
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObject invscheme;
                    boolean flag;
                    DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
                    String modeltype = dataEntity.getString("modeltype");
                    if ("B".equals(modeltype) || BIZ_TYPE.equals(dataEntity.getDynamicObject("biztype").getPkValue() + "")) continue;
                    if (dataEntity.getDynamicObject("invscheme") == null) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\uff0c\u4ee5\u786e\u4fdd\u5ba1\u6838\u901a\u8fc7\u3002", (String)"OmCmplInBillValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                        this.addErrorMessage(this.dataEntities[i], msg);
                    }
                    if (flag = "1".equals((invscheme = dataEntity.getDynamicObject("invscheme")).getString("bizdirection"))) continue;
                    DynamicObjectCollection col = dataEntity.getDynamicObjectCollection("billentry");
                    for (DynamicObject dyObj : col) {
                        manuBillIds.add(dyObj.getLong("manubillid"));
                        manuEntryIds.add(dyObj.getLong("manuentryid"));
                    }
                }
                Map<Long, Map<String, Object>> orderById = MftReqOutBillUtil.getOrderById(manuBillIds, "om_mftorder");
                Map<Object, Object> orderEntryMap = new HashMap(16);
                boolean isfirst = true;
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    String modeltype = obj.getString("modeltype");
                    if ("B".equals(modeltype)) continue;
                    DynamicObjectCollection col = obj.getDynamicObjectCollection("billentry");
                    for (DynamicObject entryObj : col) {
                        Map<String, Object> manuBill = orderById.get(entryObj.getLong("manuentryid"));
                        if (manuBill == null || !OmCmplInBillValidator.needValid(entryObj, manuBill)) {
                            return;
                        }
                        BigDecimal curQTY = entryObj.getBigDecimal("baseqty");
                        String materialNumber = entryObj.getDynamicObject("material").getDynamicObject("masterid").getString("number");
                        String materialName = entryObj.getDynamicObject("material").getDynamicObject("masterid").getString("name");
                        if (isfirst) {
                            isfirst = false;
                            List<Map<String, Object>> list = MftReqOutBillUtil.getStockByOrderEntryIdV1(manuEntryIds, "om_mftstock");
                            orderEntryMap = list.stream().collect(Collectors.groupingBy(var -> (Long)var.get("orderentryid")));
                        }
                        List mapList = (List)orderEntryMap.get(entryObj.getLong("manuentryid"));
                        BigDecimal accQty = BigDecimal.ZERO;
                        accQty = accQty.add((BigDecimal)manuBill.get("treeentryentity.quainwaqty")).add((BigDecimal)manuBill.get("treeentryentity.unquainwaqty")).add((BigDecimal)manuBill.get("treeentryentity.scrinwaqty"));
                        if (mapList == null) continue;
                        for (int i = 0; i < mapList.size(); ++i) {
                            if (null == ((Map)mapList.get(i)).get("stockentry.id") || 0L == (Long)((Map)mapList.get(i)).get("stockentry.id")) continue;
                            int precision = (Integer)((Map)mapList.get(i)).get("stockentry.materialunitid.precision");
                            String precisionaccount = (String)((Map)mapList.get(i)).get("stockentry.materialunitid.precisionaccount");
                            int deal = MftReqOutBillUtil.getPrecisionaccount(precisionaccount);
                            if (!OmCmplInBillValidator.isInRange((Map)mapList.get(i)).booleanValue()) continue;
                            HashMap<String, Object> judgeParam = new HashMap<String, Object>(32);
                            judgeParam.put("actissueqty", ((Map)mapList.get(i)).get("stockentry.actissueqty"));
                            judgeParam.put("rejectedqty", ((Map)mapList.get(i)).get("stockentry.rejectedqty"));
                            judgeParam.put("feedingqty", ((Map)mapList.get(i)).get("stockentry.feedingqty"));
                            judgeParam.put("qtytype", ((Map)mapList.get(i)).get("stockentry.qtytype"));
                            judgeParam.put("overissuecontrl", ((Map)mapList.get(i)).get("stockentry.overissuecontrl"));
                            judgeParam.put("fixscrap", ((Map)mapList.get(i)).get("stockentry.fixscrap"));
                            judgeParam.put("demandqty", ((Map)mapList.get(i)).get("stockentry.demandqty"));
                            judgeParam.put("lackraitioqty", ((Map)mapList.get(i)).get("stockentry.lackraitioqty"));
                            judgeParam.put("isconsiderloss", ((Map)mapList.get(i)).get("transactiontypeid.isconsiderloss"));
                            judgeParam.put("curQTY", curQTY);
                            judgeParam.put("accQty", accQty);
                            judgeParam.put("baseQty", ((Map)mapList.get(i)).get("baseqty"));
                            HashMap<String, Object> judgeResult = OmCmplInBillValidator.qualityJudge(judgeParam, precision, deal);
                            boolean isPass = (Boolean)judgeResult.get("isPass");
                            if (isPass) continue;
                            String pNumber = (String)((Map)mapList.get(i)).get("stockentry.materialid.masterid.number");
                            String pName = (String)((Map)mapList.get(i)).get("stockentry.materialid.masterid.name");
                            BigDecimal qtyA = (BigDecimal)judgeResult.get("qualityA");
                            BigDecimal qtyB = (BigDecimal)judgeResult.get("qualityB");
                            BigDecimal qtyT = accQty.add(curQTY);
                            String message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u5168\u9886\u6599\u7684\u7269\u6599\uff1a\u5165\u5e93\u4ea7\u54c1\u7f16\u7801\u201c%1$s\u201d\u3001\u4ea7\u54c1\u540d\u79f0\u201c%2$s\u201d \u7d2f\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf\u201c%3$s\u201d\uff0c\u7269\u6599\u7f16\u7801\u201c%4$s\u201d\u3001\u7269\u6599\u540d\u79f0\u201c%5$s\u201d\u5e94\u9886\u7528\u201c%6$s\u201d\uff0c\u5b9e\u9645\u9886\u7528\u201c%7$s\u201d\u3002", (String)"OmCmplInBillValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialNumber, materialName, qtyT.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyT.intValue()) : qtyT.setScale(precision, deal).toPlainString(), pNumber, pName, qtyB.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyB.intValue()) : qtyB.setScale(precision, deal).toPlainString(), qtyA.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyA.intValue()) : qtyA.setScale(precision, deal).toPlainString());
                            if ("A".equals(manuBill.get("transactiontype.warehouscontrol"))) {
                                this.addWarningMessage(dataEntity, message);
                                continue;
                            }
                            if (!"B".equals(manuBill.get("transactiontype.warehouscontrol"))) continue;
                            this.addErrorMessage(dataEntity, message);
                        }
                    }
                }
                break;
            }
        }
    }

    private static boolean needValid(DynamicObject entryObj, Map<String, Object> manuBill) {
        Boolean isWarehousingPick = (Boolean)manuBill.get("transactiontype.iswarehousingpick");
        if (!isWarehousingPick.booleanValue()) {
            return false;
        }
        return "C".equals(entryObj.getString("producttype"));
    }

    private static Boolean isInRange(Map<String, Object> stockMap) {
        String warehousrang = (String)stockMap.get("transactiontypeid.warehousrang");
        String issuemode = (String)stockMap.get("stockentry.issuemode");
        String isbackflush = (String)stockMap.get("stockentry.isbackflush");
        Boolean isbulkmaterial = (Boolean)stockMap.get("stockentry.isbulkmaterial");
        boolean iskeypart = (Boolean)stockMap.get("stockentry.iskeypart");
        Boolean inRangeFlag = false;
        switch (warehousrang) {
            case "A": {
                if (isbulkmaterial.booleanValue() || !"A".equals(isbackflush) || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
            case "B": {
                if (!iskeypart || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
            case "C": {
                if (isbulkmaterial.booleanValue() || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
        }
        return inRangeFlag;
    }

    private static HashMap<String, Object> qualityJudge(HashMap<String, Object> judgeParam, int precision, int deal) {
        boolean isPass;
        BigDecimal qualityA = BigDecimal.ZERO;
        BigDecimal qualityB = BigDecimal.ZERO;
        HashMap<String, Object> result = new HashMap<String, Object>();
        BigDecimal curQTY = (BigDecimal)judgeParam.get("curQTY");
        BigDecimal accQty = (BigDecimal)judgeParam.get("accQty");
        BigDecimal baseQty = (BigDecimal)judgeParam.get("baseQty");
        qualityA = qualityA.add((BigDecimal)judgeParam.get("actissueqty")).subtract((BigDecimal)judgeParam.get("rejectedqty")).add((BigDecimal)judgeParam.get("feedingqty"));
        String qtytype = (String)judgeParam.get("qtytype");
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            String overissuecontrl = (String)judgeParam.get("overissuecontrl");
            qualityB = qualityB.add(accQty).add(curQTY);
            BigDecimal fixscrap = judgeParam.get("fixscrap") == null ? BigDecimal.ZERO : (BigDecimal)judgeParam.get("fixscrap");
            qualityB = qualityB.multiply(((BigDecimal)judgeParam.get("demandqty")).subtract(fixscrap)).divide(baseQty, precision, deal);
            if ("B".equals(overissuecontrl) && qualityB.compareTo((BigDecimal)judgeParam.get("lackraitioqty")) > 0) {
                qualityB = (BigDecimal)judgeParam.get("lackraitioqty");
            }
        } else {
            qualityB = (BigDecimal)judgeParam.get("demandqty");
        }
        if (qualityA.compareTo(qualityB) >= 0) {
            isPass = true;
        } else {
            isPass = false;
            result.put("qualityA", qualityA);
            result.put("qualityB", qualityB);
        }
        result.put("isPass", isPass);
        return result;
    }
}

