/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill.validate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.opplugin.mdc.utils.MPDMMftGenStocksUtils;
import org.apache.commons.collections4.CollectionUtils;

public class OmCmplInBillXOrderValidator
extends AbstractValidator {
    private static final String KEY_SRCBILLENTRYID = "srcbillentryid";
    private static final String ENTITYID_XMFTORDER = "om_xmftorder";
    private static final String ENTITYID_ENTRY = "treeentryentity";

    public void validate() {
        String operate = this.getOperateKey();
        String operateName = String.format(ResManager.loadKDString((String)"\u5ba1\u6838", (String)"OmCmplInBillXOrderValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
        switch (operate) {
            case "delete": {
                operateName = String.format(ResManager.loadKDString((String)"\u5220\u9664", (String)"OmCmplInBillXOrderValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                break;
            }
            case "save": {
                operateName = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"OmCmplInBillXOrderValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                break;
            }
            case "submit": {
                operateName = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"OmCmplInBillXOrderValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                break;
            }
            case "submitandnew": {
                operateName = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u65b0\u589e", (String)"OmCmplInBillXOrderValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                break;
            }
            case "audit": {
                operateName = String.format(ResManager.loadKDString((String)"\u5ba1\u6838", (String)"OmCmplInBillXOrderValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                break;
            }
            case "unaudit": {
                operateName = String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"OmCmplInBillXOrderValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                break;
            }
        }
        HashSet<String> manuEntryIds = new HashSet<String>(10);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < dataEntity.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)dataEntity.getDynamicObjectCollection("billentry").get(j);
                Long mainbillentryid = entryObj.getLong("manuentryid");
                manuEntryIds.add(mainbillentryid.toString());
            }
        }
        this.checkUnAuditXmftorderInfo(this.dataEntities, manuEntryIds, operateName);
    }

    private void checkUnAuditXmftorderInfo(ExtendedDataEntity[] dataEntities, Set<String> manuEntryIds, String operateName) {
        String algoKey = "queryXOmOrderById";
        ArrayList<String> xOmftOrders = new ArrayList<String>(128);
        if (CollectionUtils.isEmpty(manuEntryIds)) {
            return;
        }
        String selectFields = "treeentryentity.srcbillentryid";
        QFilter filter = new QFilter("treeentryentity.srcbillentryid", "in", manuEntryIds);
        filter.and(new QFilter("billstatus", "!=", (Object)"C"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)ENTITYID_XMFTORDER, (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                xOmftOrders.add(row.getString("treeentryentity.srcbillentryid"));
            }
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            Map<String, Object> pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)dataEntity.getDynamicObject("org").getPkValue(), "im_mdc_omcmplinbill");
            Boolean isMftOrderCtrlBusExe = (Boolean)pmAppParameterMap.get("ismftorderctrlbusexe");
            for (int j = 0; j < dataEntity.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)dataEntity.getDynamicObjectCollection("billentry").get(j);
                String mainbillentryid = entryObj.get("manuentryid").toString();
                if (!isMftOrderCtrlBusExe.booleanValue() || !xOmftOrders.contains(mainbillentryid)) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355\u7b2c%1$s\u5206\u5f55\u5bf9\u5e94\u7684\u59d4\u5916\u5de5\u5355\u5206\u5f55\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u5355\u53d8\u66f4\u5355\uff0c%2$s\u5931\u8d25\u3002", (String)"OmCmplInBillXOrderValidator_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, operateName));
            }
        }
    }
}

