/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.consts.InvSchemeConst;

public class OmCmplinBillUnAuditAndWriteOffValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(OmCmplinBillUnAuditAndWriteOffValidator.class);
    private Map<Long, Set<Long>> verifyBillMapping = new HashMap<Long, Set<Long>>(8);
    private Map<Long, Set<Long>> verifyBillEntryMapping = new HashMap<Long, Set<Long>>(8);
    private Map<Long, Long> redBillMapping = new HashMap<Long, Long>(8);

    public void validate() {
        logger.info("common OmCmplinBillUnAuditAndWriteOffValidator");
        if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0004")) {
            logger.info("scm disenable");
            return;
        }
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        HashSet<String> keys = new HashSet<String>(16);
        keys.add("audit");
        keys.add("unaudit");
        keys.add("ominself");
        keys.add("unautoverify");
        if (!keys.contains(operateKey)) {
            return;
        }
        String entityName = dataEntities[0].getDataEntity().getDataEntityType().getName();
        HashMap<String, Object> validatorInfo = new HashMap<String, Object>(8);
        HashMap<Long, List<Long>> billIdMap = new HashMap<Long, List<Long>>(dataEntities.length);
        this.buildParam(entityName, dataEntities, billIdMap, operateKey);
        logger.info("billIdMap" + billIdMap);
        if (billIdMap.isEmpty()) {
            return;
        }
        validatorInfo.put("entityName", entityName);
        validatorInfo.put("entryKey", "billentry");
        validatorInfo.put("billIds", billIdMap);
        Map resultMap = null;
        logger.info("validatorInfo" + validatorInfo);
        try {
            resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"ICancelVerifyService", (String)"CanCancelVerify", (Object[])new Object[]{validatorInfo});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        logger.info("resultMap" + resultMap);
        Boolean success = (Boolean)resultMap.get("succed");
        Map reconciliation = (Map)resultMap.get("data");
        if (!success.booleanValue()) {
            String message = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"OmCmplinBillUnAuditAndWriteOffValidator_1", (String)"scmc-mm-om", (Object[])new Object[0]);
            switch (operateKey) {
                case "unaudit": {
                    message = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"OmCmplinBillUnAuditAndWriteOffValidator_1", (String)"scmc-mm-om", (Object[])new Object[0]);
                    break;
                }
                case "ominself": {
                    message = ResManager.loadKDString((String)"\u5e94\u4ed8\u6838\u9500", (String)"OmCmplinBillUnAuditAndWriteOffValidator_2", (String)"scmc-mm-om", (Object[])new Object[0]);
                    break;
                }
                case "unautoverify": {
                    message = ResManager.loadKDString((String)"\u5e94\u4ed8\u53cd\u6838\u9500", (String)"OmCmplinBillUnAuditAndWriteOffValidator_3", (String)"scmc-mm-om", (Object[])new Object[0]);
                }
            }
            this.addValidatorMessage(dataEntities, reconciliation, message);
        }
    }

    private void buildParam(String entityName, ExtendedDataEntity[] dataEntities, Map<Long, List<Long>> billIdMap, String operationKey) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long entryId;
            boolean negativeBill;
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject supplier = entity.getDynamicObject("supplier");
            String modeltype = entity.getString("modeltype");
            if (supplier == null || !supplier.getBoolean("issuppcolla") || "A".equals(modeltype) || ("ominself".equals(operationKey) || "unautoverify".equals(operationKey)) && (negativeBill = this.isNegativeBill(entity))) continue;
            DynamicObjectCollection billEntry = entity.getDynamicObjectCollection("billentry");
            ArrayList<Long> entryIds = new ArrayList<Long>(billEntry.size());
            Long billId = entity.getLong("id");
            if (Objects.equals("audit", operationKey) && this.isNegativeBill(entity)) {
                for (DynamicObject entry : billEntry) {
                    billId = entry.getLong("srcbillid");
                    entryId = entry.getLong("srcbillentryid");
                    entryIds.add(entryId);
                }
                this.redBillMapping.put(entity.getLong("id"), billId);
            } else {
                for (DynamicObject entry : billEntry) {
                    entryId = entry.getLong("id");
                    entryIds.add(entryId);
                }
            }
            billIdMap.put(billId, entryIds);
        }
        if (!"im_mdc_omcmplinbill".equals(entityName) || billIdMap.isEmpty()) {
            return;
        }
    }

    private void addVerifyRecordBill(Map<Long, List<Long>> billIdMap, Set<Long> orgIds) {
        Set<Long> currentBillIds = billIdMap.keySet();
        QFilter mainFilter = new QFilter("org", "in", orgIds);
        mainFilter.and("billid", "in", currentBillIds);
        mainFilter.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        mainFilter.and("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE);
        mainFilter.and("verifyrelation", "=", (Object)"purself");
        DataSet verifyRecordsByMain = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ap_verifyrecord", (String)"billid, billentryid, entry.e_billid, entry.e_billentryid", (QFilter[])mainFilter.toArray(), (String)"");
        QFilter asstFilter = new QFilter("org", "in", orgIds);
        asstFilter.and("entry.e_billid", "in", currentBillIds);
        asstFilter.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        asstFilter.and("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE);
        asstFilter.and("verifyrelation", "=", (Object)"purself");
        DataSet verifyRecordsByAsst = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ap_verifyrecord", (String)"billid, billentryid, entry.e_billid, entry.e_billentryid", (QFilter[])asstFilter.toArray(), (String)"");
        DataSet verifyRecords = verifyRecordsByMain.union(verifyRecordsByAsst);
        while (verifyRecords.hasNext()) {
            List eEntryIds;
            Row verifyRecord = verifyRecords.next();
            Long billId = verifyRecord.getLong("billid");
            Long billEntryId = verifyRecord.getLong("billentryid");
            Long eBillId = verifyRecord.getLong("entry.e_billid");
            Long eBillEntryId = verifyRecord.getLong("entry.e_billentryid");
            Set eBillIds = this.verifyBillMapping.computeIfAbsent(billId, k -> new HashSet(8));
            eBillIds.add(eBillId);
            Set billIds = this.verifyBillMapping.computeIfAbsent(eBillId, k -> new HashSet(8));
            billIds.add(billId);
            Set eBillEntryIds = this.verifyBillEntryMapping.computeIfAbsent(billEntryId, k -> new HashSet(8));
            eBillEntryIds.add(eBillEntryId);
            Set billEntryIds = this.verifyBillEntryMapping.computeIfAbsent(eBillEntryId, k -> new HashSet(8));
            billEntryIds.add(billEntryId);
            List entryIds = billIdMap.computeIfAbsent(billId, k -> new ArrayList(8));
            if (!entryIds.contains(billEntryId)) {
                entryIds.add(billEntryId);
            }
            if ((eEntryIds = billIdMap.computeIfAbsent(eBillId, k -> new ArrayList(8))).contains(eBillEntryId)) continue;
            eEntryIds.add(eBillEntryId);
        }
    }

    private void addValidatorMessage(ExtendedDataEntity[] dataEntities, Map<Long, List<Long>> reconciliation, String operationKey) {
        Set<Long> billIds = reconciliation.keySet();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String billNo = bill.getString("billno");
            Long billId = bill.getLong("id");
            Set<Long> verifyBillIds = this.checkVerifyBill(billIds, billId);
            if (!billIds.contains(billId) && verifyBillIds.isEmpty() && (!this.redBillMapping.containsKey(billId) || !billIds.contains(this.redBillMapping.get(billId)))) continue;
            List<Long> entryIds = this.getEntryIds(reconciliation, verifyBillIds, billId);
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            if (this.redBillMapping.containsKey(billId) && billIds.contains(this.redBillMapping.get(billId))) {
                entryIds = billEntry.stream().map(x -> (Long)x.getPkValue()).collect(Collectors.toList());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(billNo);
                stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u84dd\u5355", (String)"OmCmplinBillUnAuditAndWriteOffValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                billNo = stringBuilder.toString();
            }
            if (entryIds == null || entryIds.isEmpty()) continue;
            for (DynamicObject entry : billEntry) {
                Long entryId = entry.getLong("id");
                if (!entryIds.contains(entryId)) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5bf9\u8d26\u5f00\u7968\uff0c\u65e0\u6cd5\u8fdb\u884c\u4ee5\u4e0b\u64cd\u4f5c\uff1a1\u3001\u5165\u5e93\u7ea2\u51b2\u6838\u9500\uff08\u5305\u62ec\u81ea\u52a8\u6838\u9500\u3001\u624b\u5de5\u6838\u9500\uff09\uff1b2\u3001\u5165\u5e93\u7ea2\u51b2\u53cd\u6838\u9500\uff1b3\u3001\u5355\u636e\u53cd\u5ba1\u6838\u3002", (String)"OmCmplinBillUnAuditAndWriteOffValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), billNo));
            }
        }
    }

    private List<Long> getEntryIds(Map<Long, List<Long>> reconciliation, Set<Long> verifyBillIds, Long billId) {
        List<Long> entryIds = reconciliation.get(billId);
        if (verifyBillIds.isEmpty()) {
            return entryIds;
        }
        HashSet<Long> verifyEntryIds = new HashSet<Long>(8);
        for (Long verifyBillId : verifyBillIds) {
            List<Long> entryIdList = reconciliation.get(verifyBillId);
            verifyEntryIds.addAll(entryIdList);
        }
        HashSet<Long> currentEntryIds = new HashSet<Long>(8);
        for (Long verifyEntryId : verifyEntryIds) {
            Set<Map.Entry<Long, Set<Long>>> entries = this.verifyBillEntryMapping.entrySet();
            for (Map.Entry<Long, Set<Long>> entry : entries) {
                Set<Long> value = entry.getValue();
                if (!value.contains(verifyEntryId)) continue;
                currentEntryIds.add(entry.getKey());
            }
        }
        if (entryIds != null) {
            currentEntryIds.addAll(entryIds);
        }
        return new ArrayList<Long>(currentEntryIds);
    }

    private Set<Long> checkVerifyBill(Set<Long> billIds, Long billId) {
        Set<Long> verifyBillIds = this.verifyBillMapping.get(billId);
        HashSet<Long> ids = new HashSet<Long>(8);
        if (verifyBillIds == null || verifyBillIds.isEmpty()) {
            return ids;
        }
        for (Long verifyBillId : verifyBillIds) {
            boolean contains = billIds.contains(verifyBillId);
            if (!contains) continue;
            ids.add(verifyBillId);
        }
        return ids;
    }

    private boolean isNegativeBill(DynamicObject order) {
        DynamicObject invscheme = order.getDynamicObject("invscheme");
        if (invscheme == null) {
            return false;
        }
        boolean isNegativeBill = false;
        DynamicObject transceiverType = (invscheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invscheme.getPkValue(), (String)"im_invscheme", (String)InvSchemeConst.getAllSelector())).getDynamicObject("transceivertype");
        String bizdirection = transceiverType.getString("bizdirection");
        if ("1".equals(bizdirection)) {
            isNegativeBill = true;
        }
        return isNegativeBill;
    }
}

