/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill.validate;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OmCmplinChargeagainstValidator
extends AbstractValidator {
    public void validate() {
        String billname;
        String operate = this.getOperateKey();
        boolean flag = false;
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            String modeltype = dataEntity.getString("modeltype");
            if (!"B".equals(modeltype)) continue;
            flag = true;
        }
        String billtype = flag ? "pom_mftorder" : "om_mftorder";
        String string = billname = flag ? ResManager.loadKDString((String)"\u751f\u4ea7", (String)"OmCmplinChargeagainstValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u59d4\u5916", (String)"OmCmplinChargeagainstValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        if ("chargeagainst".equals(operate)) {
            HashSet<Long> manuEntryId = new HashSet<Long>(10);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    manuEntryId.add(entryObj.getLong("manuentryid"));
                }
            }
            Map<String, Map<String, String>> mftOrder = this.getMftOrder(manuEntryId, billtype);
            HashSet orderBizStatus = Sets.newHashSet((Object[])new String[]{"B", "C", "D"});
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                this.validateOmOrder(obj, mftOrder, orderBizStatus, i, billname);
            }
        }
    }

    private void validateOmOrder(DynamicObject obj, Map<String, Map<String, String>> mftOrder, Set<String> orderBizStatus, int i, String billname) {
        for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
            DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
            if (0L == entryObj.getLong("manubillid")) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5206\u5f55%2$s\u5de5\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"OmCmplinChargeagainstValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, billname));
                continue;
            }
            Map<String, String> manuObj = mftOrder.get(entryObj.getString("manuentryid"));
            if (manuObj == null) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5206\u5f55%2$s\u5de5\u5355\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"OmCmplinChargeagainstValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, billname));
                continue;
            }
            if (!"C".equals(manuObj.get("billstatus"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5206\u5f55%2$s\u5de5\u5355\u4e0d\u4e3a\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"OmCmplinChargeagainstValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, billname));
                continue;
            }
            String bizStatus = manuObj.get("bizstatus");
            if (obj.getBoolean("isvirtualbill") || !orderBizStatus.contains(bizStatus)) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5206\u5f55%2$s\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e3a\uff1a\u6302\u8d77/\u5173\u95ed/\u7ed3\u6848\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"OmCmplinChargeagainstValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, billname));
        }
    }

    private Map<String, Map<String, String>> getMftOrder(Set<Long> manuEntryId, String billtype) {
        String algoKey = "queryMftOrder";
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.seq,treeentryentity.producttype,treeentryentity.material,treeentryentity.iscontrolqty,treeentryentity.inwarmax,treeentryentity.inwarmin,treeentryentity.quainwaqty,treeentryentity.waitcheckqty,treeentryentity.unquainwaqty,treeentryentity.scrinwaqty,treeentryentity.bizstatus,treeentryentity.planstatus";
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(256);
        QFilter qFilter = new QFilter("treeentryentity.id", "in", manuEntryId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)billtype, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("treeentryentity.id", row.getString("treeentryentity.id"));
                map1.put("bizstatus", row.getString("treeentryentity.bizstatus"));
                map1.put("planstatus", row.getString("treeentryentity.planstatus"));
                map1.put("seq", row.getString("treeentryentity.seq"));
                map.put(row.getString("treeentryentity.id"), map1);
            }
        }
        return map;
    }
}

