/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.omoutbill;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class OMCmplInBillAuditValidator
extends AbstractValidator {
    public void validate() {
        String operateKey;
        switch (operateKey = this.getOperateKey()) {
            case "audit": {
                this.auditValidate();
                break;
            }
            case "unaudit": {
                this.unAuditValidate();
                break;
            }
        }
    }

    private void auditValidate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        HashSet<Long> manuEntryIdList = new HashSet<Long>(10);
        HashSet<Long> manuBillIds = new HashSet<Long>(10);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i].getDataEntity();
            String modeltype = dataEntity.getString("modeltype");
            if ("B".equals(modeltype)) continue;
            DynamicObjectCollection billEntry = dataEntities[i].getDataEntity().getDynamicObjectCollection("billentry");
            for (DynamicObject dynamicObjects : billEntry) {
                manuBillIds.add(dynamicObjects.getLong("manubillid"));
                manuEntryIdList.add(dynamicObjects.getLong("manuentryid"));
            }
        }
        Map<Long, Map<String, Object>> orderById = MftReqOutBillUtil.getOrderById(manuBillIds, "om_mftorder");
        Map<Long, Map<String, Object>> omMfttechnicsMaps = this.getOmTechnicsMap(manuEntryIdList);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i].getDataEntity();
            String modeltype = dataEntity.getString("modeltype");
            if ("B".equals(modeltype)) continue;
            DynamicObjectCollection billEntry = dataEntities[i].getDataEntity().getDynamicObjectCollection("billentry");
            for (DynamicObject dynamicObjects : billEntry) {
                Long manuentryid;
                Map<String, Object> manuBillMap;
                if ("AB".contains(dynamicObjects.getString("producttype")) || null == (manuBillMap = orderById.get(manuentryid = Long.valueOf(dynamicObjects.getLong("manuentryid")))) || MapUtils.isEmpty(manuBillMap) || "false".equals(manuBillMap.get("transactiontype.isprocedure"))) continue;
                Map<String, Object> mfttechnicsMap = omMfttechnicsMaps.get(manuentryid);
                if (null == mfttechnicsMap || MapUtils.isEmpty(mfttechnicsMap)) {
                    this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u8be5\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355\u6ca1\u6709\u5de5\u5e8f\u8ba1\u5212\u3002", (String)"OMCmplInBillAuditValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    return;
                }
                if ("C".equals(mfttechnicsMap.get("billstatus"))) continue;
                this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u8be5\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355\u5173\u8054\u7684\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\u3002", (String)"OMCmplInBillAuditValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return;
            }
        }
    }

    private Map<Long, Map<String, Object>> getOmTechnicsMap(Set<Long> manuEntryIdList) {
        String algoKey = "queryOmTechnicsById";
        HashMap<Long, Map<String, Object>> map = new HashMap<Long, Map<String, Object>>(128);
        if (CollectionUtils.isEmpty(manuEntryIdList)) {
            return map;
        }
        QFilter qFilter = new QFilter("mftentryseq", "in", manuEntryIdList);
        String selectFields = "billstatus,mftentryseq";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"om_mfttechnics", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map1 = new HashMap<String, Object>(64);
                map1.put("mftentryseq", row.getLong("mftentryseq"));
                map1.put("billstatus", row.getString("billstatus"));
                map.put(row.getLong("mftentryseq"), map1);
            }
        }
        return map;
    }

    private void unAuditValidate() {
        Long manuBillId;
        DynamicObjectCollection billEntry;
        String modeltype;
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        HashSet<Long> manuBillIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            modeltype = dataEntity.getDataEntity().getString("modeltype");
            if ("B".equals(modeltype)) continue;
            billEntry = dataEntity.getDataEntity().getDynamicObjectCollection("billentry");
            for (DynamicObject dynamicObjects : billEntry) {
                manuBillId = dynamicObjects.getLong("manubillid");
                if (manuBillId == null || manuBillId == 0L) continue;
                manuBillIds.add(manuBillId);
            }
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", manuBillIds)};
        DynamicObject[] mftorders = BusinessDataServiceHelper.load((String)"om_mftorder", (String)"id,transactiontype", (QFilter[])qFilters);
        Map<Long, List<DynamicObject>> id_mftorder = Arrays.stream(mftorders).collect(Collectors.groupingBy(e -> e.getLong("id")));
        for (int i = 0; i < dataEntities.length; ++i) {
            modeltype = dataEntities[i].getDataEntity().getString("modeltype");
            if ("B".equals(modeltype)) continue;
            billEntry = dataEntities[i].getDataEntity().getDynamicObjectCollection("billentry");
            for (DynamicObject dynamicObjects : billEntry) {
                QFilter qfilter_2;
                QFilter qfilter_1;
                boolean exists;
                manuBillId = dynamicObjects.getLong("manubillid");
                if (manuBillId == null || manuBillId == 0L) {
                    String msg = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355id\u4e0d\u5b58\u5728\u3002", (String)"OMCmplInBillAuditValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntities[i], msg);
                    continue;
                }
                List<DynamicObject> mftorder = id_mftorder.get(manuBillId);
                if (mftorder.isEmpty()) {
                    String billNotMgs = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u4e0d\u5b58\u5728\u3002", (String)"OMCmplInBillAuditValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntities[i], billNotMgs);
                    continue;
                }
                DynamicObject transactionType = mftorder.get(0).getDynamicObject("transactiontype");
                if (!transactionType.getBoolean("isprocedure") || !(exists = QueryServiceHelper.exists((String)"om_processreport", (QFilter[])new QFilter[]{qfilter_1 = new QFilter("sumentry.manufactureid", "=", (Object)String.valueOf(manuBillId)), qfilter_2 = new QFilter("sumentry.manuinbillentryid", "=", (Object)String.valueOf(dynamicObjects.getPkValue()))}))) continue;
                String errMgs = ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u59d4\u5916\u5de5\u5e8f\u6c47\u62a5\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"OMCmplInBillAuditValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                this.addErrorMessage(dataEntities[i], errMgs);
            }
        }
    }
}

