/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.omoutbill;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.helper.OmOrderBookDateHelper;

public class OMOutReqBillOp
extends AbstractOperationServicePlugIn {
    private static final String KEY_AUDIT = "audit";
    private static final String KEY_UNAUDIT = "unaudit";
    private static final String KEY_BILLENTRY = "billentry";
    private static final String KEY_MANUENTRYID = "manuentryid";
    private static final String KEY_MANUBILLID = "manubillid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("manubill");
        e.getFieldKeys().add(KEY_MANUBILLID);
        e.getFieldKeys().add("manuentry");
        e.getFieldKeys().add(KEY_MANUENTRYID);
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("reqtype");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("isbackflush");
        e.getFieldKeys().add("billentry.ecostcenter");
        e.getFieldKeys().add("billentry.isadd");
        e.getFieldKeys().add("billentry.isrework");
        e.getFieldKeys().add("bizdept");
        e.getFieldKeys().add("isvirtualbill");
        e.getFieldKeys().add("bizorg");
        e.getFieldKeys().add("bookdate");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dObjects = e.getDataEntities();
        if (KEY_AUDIT.equals(operationKey) || KEY_UNAUDIT.equals(operationKey)) {
            HashSet<String> orderEntryids = new HashSet<String>(20);
            HashSet<String> orderids = new HashSet<String>(20);
            for (DynamicObject repOut : dObjects) {
                if (repOut.getBoolean("ischargeoff")) {
                    return;
                }
                DynamicObjectCollection entryCol = repOut.getDynamicObjectCollection(KEY_BILLENTRY);
                for (DynamicObject billEntry : entryCol) {
                    orderids.add(billEntry.get(KEY_MANUBILLID).toString());
                    orderEntryids.add(billEntry.get(KEY_MANUENTRYID).toString());
                }
            }
            if (!orderEntryids.isEmpty()) {
                this.autoAculUseAndCloseOrder(operationKey, orderEntryids, orderids);
            }
            if (KEY_AUDIT.equals(operationKey)) {
                String entityTypeName = this.billEntityType.getName();
                if (StringUtils.equals((CharSequence)BillTypeEnum.PRO_BILL.getName(), (CharSequence)entityTypeName) || StringUtils.equals((CharSequence)BillTypeEnum.FEED_BILL.getName(), (CharSequence)entityTypeName) || StringUtils.equals((CharSequence)BillTypeEnum.RETURN_BILL.getName(), (CharSequence)entityTypeName)) {
                    OmOrderBookDateHelper helper = new OmOrderBookDateHelper(dObjects, "om_mftorder", KEY_BILLENTRY, KEY_MANUBILLID, KEY_MANUENTRYID);
                    helper.updateOrderBookDateByBizBill();
                }
            }
        }
    }

    private void autoAculUseAndCloseOrder(String operationKey, Set<String> orderEntryids, Set<String> orderids) {
        HashMap<String, Object> calparam = new HashMap<String, Object>();
        calparam.put("orderentryids", orderEntryids);
        calparam.put("orderids", orderids);
        calparam.put("operate", operationKey);
        calparam.put("iscloseorder", "1");
        calparam.put("isautocal", "0");
        calparam.put("isautoflag", "0");
        calparam.put("modetype", "2");
        calparam.put("appId", "im");
        String jsonString = JSON.toJSONString(calparam);
        EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
    }
}

