/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.omoutbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.enums.OperateEnum;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import kd.scmc.im.opplugin.mdc.utils.MPDMMftGenStocksUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OMOutStockBillValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOperateKey();
        HashSet<Long> set = new HashSet<Long>(10);
        HashSet<String> manuEntryIds = new HashSet<String>(10);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                set.add(entryObj.getLong("mainbillid"));
                manuEntryIds.add(entryObj.getString("manuentryid"));
            }
        }
        Map<String, Map<String, String>> mftStock = MftReqOutBillUtil.getMftStockByIds(set, "om_mftstock");
        Map<String, Map<String, String>> xmftStock = MftReqOutBillUtil.getXmftStockByStockId(set, "om_xmftstock");
        Map<String, Map<String, String>> xmftOrder = MftReqOutBillUtil.getXmftOrderByManuEntryId(manuEntryIds, "om_xmftorder");
        this.doValidate(operate, mftStock);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                String format;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                String mainBillId = entryObj.getString("mainbillid");
                String manuEntryId = entryObj.getString("manuentryid");
                Map<String, String> map = mftStock.get(mainBillId);
                if (map == null) {
                    format = String.format(ResManager.loadKDString((String)"%s\uff1a\u6ca1\u6709\u5bf9\u5e94\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"OMOutStockBillValidator_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                if (StringUtils.equals((CharSequence)mainBillId, (CharSequence)map.get("id")) && !StringUtils.equals((CharSequence)"C", (CharSequence)map.get("billstatus"))) {
                    format = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5bf9\u5e94\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355%2$s\u672a\u5ba1\u6838\uff0c%3$s\u5931\u8d25\u3002", (String)"OMOutStockBillValidator_9", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), map.get("billno"), OperateEnum.getValue(operate));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                Map<String, Object> pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)obj.getDynamicObject("bizorg").getPkValue(), "im_mdc_omoutbill");
                Boolean isMftStockCtrlBusExe = pmAppParameterMap.containsKey("ismftstockctrlbusexe") ? (Boolean)pmAppParameterMap.get("ismftstockctrlbusexe") : false;
                Map<String, String> stringMap = xmftStock.get(mainBillId);
                if (isMftStockCtrlBusExe.booleanValue() && !obj.getBoolean("isvirtualbill") && stringMap != null && StringUtils.equals((CharSequence)mainBillId, (CharSequence)stringMap.get("stockentry.stockid"))) {
                    String format2 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5bf9\u5e94\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355%2$s\u672a\u5ba1\u6838\uff0c%3$s\u5931\u8d25\u3002", (String)"OMOutStockBillValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), stringMap.get("billno"), OperateEnum.getValue(operate));
                    this.addErrorMessage(this.dataEntities[i], format2);
                    continue;
                }
                Boolean isMftOrderCtrlBusExe = pmAppParameterMap.containsKey("ismftorderctrlbusexe") ? (Boolean)pmAppParameterMap.get("ismftorderctrlbusexe") : false;
                Map<String, String> xmftOrderMap = xmftOrder.get(manuEntryId);
                if (!isMftOrderCtrlBusExe.booleanValue() || obj.getBoolean("isvirtualbill") || xmftOrderMap == null || !StringUtils.equals((CharSequence)manuEntryId, (CharSequence)xmftOrderMap.get("treeentryentity.srcbillentryid"))) continue;
                String format3 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5bf9\u5e94\u7684\u59d4\u5916\u5de5\u5355\u53d8\u66f4\u5355%2$s\u672a\u5ba1\u6838\uff0c%3$s\u5931\u8d25\u3002", (String)"OMOutStockBillValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), xmftOrderMap.get("billno"), OperateEnum.getValue(operate));
                this.addErrorMessage(this.dataEntities[i], format3);
            }
        }
    }

    private void doValidate(String operate, Map<String, Map<String, String>> mftStock) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Long[] longs = this.getWarehouse(obj);
            HashSet<Long> seqSet = new HashSet<Long>(16);
            String billEntityName = obj.getDataEntityType().getName();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                Object mainbillid = entryObj.get("mainbillid");
                if ("delete".equals(operate) && (mainbillid == null || 0L == entryObj.getLong("mainbillid"))) {
                    return;
                }
                if (!(entryObj.getBoolean("isadd") || entryObj.getLong("mainbillentryid") <= 0L || mainbillid != null && 0L != entryObj.getLong("mainbillid"))) {
                    String format = String.format(ResManager.loadKDString((String)"%s\uff1a\u6ca1\u6709\u5bf9\u5e94\u7684\u6838\u5fc3\u5355\u636eid\u3002", (String)"OMOutStockBillValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                if (!"delete".equals(operate)) {
                    DynamicObject warehouse = entryObj.getDynamicObject("warehouse");
                    DynamicObject location = entryObj.getDynamicObject("location");
                    if (warehouse != null) {
                        String format;
                        if (longs == null || longs.length == 0) {
                            String format2 = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c%2$s\u5931\u8d25\u3002", (String)"OMOutStockBillValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, OperateEnum.getValue(operate));
                            this.addErrorMessage(this.dataEntities[i], format2);
                            continue;
                        }
                        List<Long> list = Arrays.asList(longs);
                        if (!list.contains(warehouse.getPkValue())) {
                            format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c%2$s\u5931\u8d25\u3002", (String)"OMOutStockBillValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, OperateEnum.getValue(operate));
                            this.addErrorMessage(this.dataEntities[i], format);
                            continue;
                        }
                        if (warehouse.getBoolean("isopenlocation")) {
                            List locationIds = WarehouseHelper.getLocationIds((Object)warehouse.getPkValue());
                            if (location != null && !locationIds.contains(location.getLong("id"))) {
                                String format3 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$d\u884c\u5206\u5f55\u7684\u4ed3\u5e93\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u4e0e\u4ed3\u5e93\u4e0d\u7b26\uff0c%3$s\u5931\u8d25\u3002", (String)"OMOutStockBillValidator_10", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), j + 1, OperateEnum.getValue(operate));
                                this.addErrorMessage(this.dataEntities[i], format3);
                                continue;
                            }
                        } else if (location != null) {
                            format = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%d\u884c\u5206\u5f55\u7684\u4ed3\u5e93\u672a\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u6709\u503c\uff0c%2$s\u5931\u8d25\u3002", (String)"OMOutStockBillValidator_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), j + 1, OperateEnum.getValue(operate));
                            this.addErrorMessage(this.dataEntities[i], format);
                            continue;
                        }
                    }
                }
                Map<String, String> map = mftStock.get(null == mainbillid ? "0" : mainbillid.toString());
                boolean isUpdateStock = null == map || null == map.get("transactiontypeisupdatestock") ? false : Boolean.parseBoolean(map.get("transactiontypeisupdatestock"));
                DynamicObject bdmaterial = entryObj.getDynamicObject("material");
                if (!"submit".equals(operate) && !"audit".equals(operate) || !isUpdateStock || !entryObj.getBoolean("isadd")) continue;
                if (null != bdmaterial && entryObj.getLong("mainbillentryid") == 0L) {
                    DynamicObject bizorg = obj.getDynamicObject("bizorg");
                    QFilter mftmaterialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.parseLong(bizorg.getPkValue().toString()));
                    mftmaterialFilter.and(new QFilter("masterid", "=", bdmaterial.getDynamicObject("masterid").get("id")));
                    mftmaterialFilter.and(new QFilter("enable", "=", (Object)"1"));
                    mftmaterialFilter.and(new QFilter("status", "=", (Object)"C"));
                    DynamicObject mftmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{mftmaterialFilter});
                    if (null == mftmaterial) {
                        String format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u672a\u521b\u5efa\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6%2$s\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"OMOutStockBillValidator_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), entryObj.getInt("seq"), entryObj.getString("materialname"));
                        this.addErrorMessage(this.dataEntities[i], format);
                    }
                }
                String reqtype = obj.getString("reqtype");
                if (!StringUtils.equals((CharSequence)"im_mdc_omfeedbill", (CharSequence)billEntityName) || !StringUtils.equals((CharSequence)"A", (CharSequence)reqtype)) continue;
                seqSet.add(entryObj.getLong("seq"));
            }
            if (kd.bos.orm.util.CollectionUtils.isEmpty(seqSet)) continue;
            String info = ResManager.loadKDString((String)"\u9886\u6599\u7c7b\u578b\u4e3a\u5b9a\u989d\u9886\u6599\uff0c\u4e0d\u5141\u8bb8\u7ec4\u4ef6\u5916\u9886\u6599\u3002", (String)"OMOutStockBillValidator_13", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            this.addErrorMessage(this.dataEntities[i], info);
        }
    }

    private Long[] getWarehouse(DynamicObject obj) {
        String formId = obj.getDataEntityType().getName();
        DynamicObject org = obj.getDynamicObject("org");
        if (org == null) {
            return null;
        }
        List<Long> result = this.setWareHouseIsolate(formId, org.getLong("id"));
        if (result == null) {
            return WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
        }
        return result.toArray(new Long[result.size()]);
    }

    private List<Long> setWareHouseIsolate(String formId, Long id) {
        long userId = UserServiceHelper.getCurrentUserId();
        Object wareHouseIsolate = AppParameterHelper.getAppParameterByFormId((String)formId, (Long)id, (String)"fwarehouseisolate");
        if (wareHouseIsolate instanceof Boolean && !((Boolean)wareHouseIsolate).booleanValue()) {
            return null;
        }
        List wareHouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId((Long)userId, Collections.singletonList(id));
        if (CollectionUtils.isEmpty((Collection)wareHouses)) {
            return null;
        }
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(16);
        for (DynamicObject wareHose : wareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            wareHouseIds.add(wareHosePkValue);
        }
        return wareHouseIds;
    }
}

