/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scmc.im.common.mdc.utils.EntityNameUtils;

public class MPDMMftGenStocksUtils {
    private static final String TREEENTRYENTITYID = "treeentryentity.id";
    private static final ThreadLocal<Map<String, Map<String, Object>>> orderQtyThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, DynamicObject>> manuftechThreadLocal = new ThreadLocal();

    public static BigDecimal calculateStandQty(DynamicObject unit, String qtyType, BigDecimal useratio, BigDecimal orderQty, BigDecimal qtynumerator, BigDecimal qtydenominator) {
        BigDecimal standQty = BigDecimal.ZERO;
        if (qtydenominator.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(new ErrorCode("stock", ResManager.loadKDString((String)"\u5206\u6bcd\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"MPDMMftGenStocksUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0])), new Object[0]);
        }
        if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"A") || StringUtils.equals((CharSequence)qtyType, (CharSequence)"C")) {
            standQty = orderQty.multiply(useratio).multiply(qtynumerator).divide(qtydenominator, MPDMMftGenStocksUtils.getPrecision(unit), MPDMMftGenStocksUtils.getRoundType(unit));
        } else if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"B")) {
            standQty = useratio.multiply(qtynumerator).divide(qtydenominator, MPDMMftGenStocksUtils.getPrecision(unit), MPDMMftGenStocksUtils.getRoundType(unit));
        }
        return standQty;
    }

    public static int getPrecision(DynamicObject entryunit) {
        if (entryunit == null) {
            return 2;
        }
        return entryunit.get("precision") == null ? 2 : entryunit.getInt("precision");
    }

    public static int getRoundType(DynamicObject unit) {
        if (unit == null) {
            return 4;
        }
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    public static BigDecimal calculateDemadQty(int precision, boolean isconsiderloss, BigDecimal standqty, BigDecimal scraprate, BigDecimal fixscrap, String wastagerateformula) {
        BigDecimal demandQty = isconsiderloss ? ("A".equals(wastagerateformula) ? standqty.divide(BigDecimal.ONE.subtract(scraprate), precision, 4).add(fixscrap) : ("B".equals(wastagerateformula) ? standqty.multiply(BigDecimal.ONE.add(scraprate)).add(fixscrap) : standqty)) : standqty;
        if (standqty.compareTo(BigDecimal.ZERO) == 0) {
            demandQty = BigDecimal.ZERO;
        }
        demandQty = demandQty.setScale(precision, 4);
        return demandQty;
    }

    public static Object aculActissueQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
            if (stockEntry.getBoolean("iscannegative")) {
                actissueQty = stockEntry.getBigDecimal("demandqty");
            }
            return actissueQty;
        }
        return null;
    }

    public static Object aculCanSendQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal demand = stockEntry.getBigDecimal("extraratioqty");
            BigDecimal actissue = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejecte = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feeding = stockEntry.getBigDecimal("feedingqty");
            BigDecimal scrap = stockEntry.getBigDecimal("scrapqty");
            BigDecimal cansend = BigDecimal.ZERO;
            cansend = cansend.add(demand == null ? BigDecimal.ZERO : demand);
            cansend = cansend.add(rejecte == null ? BigDecimal.ZERO : rejecte);
            cansend = cansend.subtract(actissue == null ? BigDecimal.ZERO : actissue);
            cansend = cansend.subtract(feeding == null ? BigDecimal.ZERO : feeding);
            if ((cansend = cansend.subtract(scrap == null ? BigDecimal.ZERO : scrap)).compareTo(BigDecimal.ZERO) < 0) {
                cansend = BigDecimal.ZERO;
            }
            return cansend;
        }
        return null;
    }

    public static Object aculUnSendQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal demand = stockEntry.getBigDecimal("demandqty");
            BigDecimal actissue = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejecte = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feeding = stockEntry.getBigDecimal("feedingqty");
            BigDecimal scrap = stockEntry.getBigDecimal("scrapqty");
            BigDecimal cansend = BigDecimal.ZERO;
            cansend = cansend.add(demand == null ? BigDecimal.ZERO : demand);
            cansend = cansend.add(rejecte == null ? BigDecimal.ZERO : rejecte);
            cansend = cansend.subtract(actissue == null ? BigDecimal.ZERO : actissue);
            cansend = cansend.subtract(feeding == null ? BigDecimal.ZERO : feeding);
            cansend = cansend.subtract(scrap == null ? BigDecimal.ZERO : scrap);
            return cansend;
        }
        return null;
    }

    public static BigDecimal aculUseQty(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        return MPDMMftGenStocksUtils.culUseQty(stockEntry, orderEntryId, transactiontype, orderName);
    }

    public static BigDecimal culUseQty(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        if (stockEntry.getBoolean("iscannegative")) {
            return BigDecimal.ZERO;
        }
        String deduction = transactiontype.getString("deduction");
        if ("A".equals(deduction)) {
            return MPDMMftGenStocksUtils.aculUseQtyA(stockEntry, orderEntryId, orderName);
        }
        if ("B".equals(deduction)) {
            return MPDMMftGenStocksUtils.aculUseQtyB(stockEntry, orderEntryId, transactiontype, orderName);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal aculUseQtyA(DynamicObject stockEntry, Object orderEntryId, String orderName) {
        Map<String, Object> orderMap = MPDMMftGenStocksUtils.getOrderQtyMap(orderEntryId, orderName);
        if (orderMap.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        BigDecimal stockqty = BigDecimal.ZERO;
        BigDecimal quainwaqty = (BigDecimal)orderMap.get("quainwaqty");
        BigDecimal unquainwaqty = (BigDecimal)orderMap.get("unquainwaqty");
        BigDecimal scrinwaqty = (BigDecimal)orderMap.get("scrinwaqty");
        stockqty = quainwaqty.add(unquainwaqty).add(scrinwaqty);
        orderBaseQty = (BigDecimal)orderMap.get("baseqty");
        String qtytype = stockEntry.getString("qtytype");
        BigDecimal useQty = BigDecimal.ZERO;
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            useQty = stockqty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
        }
        if ("B".equals(qtytype)) {
            useQty = stockqty.compareTo(orderBaseQty) >= 0 ? stockEntry.getBigDecimal("demandqty") : BigDecimal.ZERO;
        }
        return useQty;
    }

    private static Map<String, Object> getOrderQtyMap(Object orderEntryId, String orderName) {
        Map<String, Object> dataMap;
        String orderKeys = String.valueOf(orderEntryId) + orderName;
        Map<String, Map<String, Object>> orderQtyDataMap = orderQtyThreadLocal.get();
        if (orderQtyDataMap == null) {
            orderQtyDataMap = new HashMap<String, Map<String, Object>>();
            orderQtyThreadLocal.set(orderQtyDataMap);
        }
        if ((dataMap = orderQtyDataMap.get(orderKeys)) != null && !dataMap.isEmpty()) {
            return dataMap;
        }
        QFilter qfilter = new QFilter(TREEENTRYENTITYID, "=", orderEntryId);
        dataMap = new HashMap<String, Object>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-StockCulUtils-getOrderQtyMap", (String)orderName, (String)"treeentryentity.baseqty baseqty ,treeentryentity.qty qty,treeentryentity.reportqty reportqty,treeentryentity.quainwaqty quainwaqty,treeentryentity.unquainwaqty unquainwaqty ,treeentryentity.scrinwaqty scrinwaqty ", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                dataMap.put("baseqty", "0E-10".equals(dsRow.getString("baseqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("baseqty"));
                dataMap.put("quainwaqty", "0E-10".equals(dsRow.getString("quainwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("quainwaqty"));
                dataMap.put("unquainwaqty", "0E-10".equals(dsRow.getString("unquainwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("unquainwaqty"));
                dataMap.put("scrinwaqty", "0E-10".equals(dsRow.getString("scrinwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("scrinwaqty"));
                dataMap.put("qty", "0E-10".equals(dsRow.getString("qty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("qty"));
                dataMap.put("reportqty", "0E-10".equals(dsRow.getString("reportqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("reportqty"));
            }
        }
        orderQtyDataMap.put(orderKeys, dataMap);
        return dataMap;
    }

    public static BigDecimal aculUseQtyB(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        BigDecimal useQty = BigDecimal.ZERO;
        if (transactiontype.getBoolean("isprocedure")) {
            useQty = MPDMMftGenStocksUtils.aculUseQtyC(stockEntry, orderEntryId, orderName);
        } else {
            Map<String, Object> orderMap = MPDMMftGenStocksUtils.getOrderQtyMap(orderEntryId, orderName);
            if (orderMap.isEmpty()) {
                return BigDecimal.ZERO;
            }
            BigDecimal orderBaseQty = BigDecimal.ONE;
            BigDecimal reportQty = BigDecimal.ZERO;
            orderBaseQty = (BigDecimal)orderMap.get("qty");
            reportQty = (BigDecimal)orderMap.get("reportqty");
            if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                orderBaseQty = BigDecimal.ONE;
            }
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            String qtytype = stockEntry.getString("qtytype");
            if ("A".equals(qtytype) || "C".equals(qtytype)) {
                useQty = reportQty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
            }
            if ("B".equals(qtytype)) {
                useQty = reportQty.compareTo(orderBaseQty) >= 0 ? demandBaseQty : BigDecimal.ZERO;
            }
        }
        return useQty;
    }

    public static BigDecimal aculUseQtyC(DynamicObject stockEntry, Object orderEntryId, String orderName) {
        BigDecimal useQty = BigDecimal.ZERO;
        BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
        DynamicObject manftechDym = MPDMMftGenStocksUtils.getManufTechDy(orderEntryId, orderName);
        if (manftechDym == null) {
            return useQty;
        }
        String processseq = stockEntry.getString("processseq");
        String oprno = stockEntry.getString("oprno");
        DynamicObjectCollection workPlanEntrys = manftechDym.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject workPlanEntry : workPlanEntrys) {
            if (!processseq.equals(workPlanEntry.getString("oprparent")) || !oprno.equals(workPlanEntry.getString("oprno"))) continue;
            BigDecimal orderBaseQty = MPDMMftGenStocksUtils.getOrderBaseQty(orderEntryId, orderName);
            BigDecimal oprtotalReportQty = workPlanEntry.getBigDecimal("oprtotalreportbaseqty");
            String qtytype = stockEntry.getString("qtytype");
            if ("A".equals(qtytype) || "C".equals(qtytype)) {
                useQty = oprtotalReportQty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
            }
            if (!"B".equals(qtytype)) continue;
            if (oprtotalReportQty.compareTo(orderBaseQty) >= 0) {
                useQty = demandBaseQty;
                continue;
            }
            useQty = BigDecimal.ZERO;
        }
        return useQty;
    }

    private static DynamicObject getManufTechDy(Object orderEntryId, String orderName) {
        DynamicObject manftechDym;
        String orderKeys = String.valueOf(orderEntryId) + orderName;
        Map<String, DynamicObject> techMap = manuftechThreadLocal.get();
        if (techMap == null) {
            techMap = new HashMap<String, DynamicObject>();
            manuftechThreadLocal.set(techMap);
        }
        if ((manftechDym = techMap.get(orderKeys)) != null) {
            return manftechDym;
        }
        if (techMap.containsKey(orderKeys)) {
            return manftechDym;
        }
        QFilter filter = new QFilter("mftentryseq", "=", orderEntryId);
        manftechDym = BusinessDataServiceHelper.loadSingle((String)"sfc_manftech", (String)"baseqty,oprentryentity.oprtotalreportqty,oprentryentity.oprtotalreportbaseqty,oprentryentity.oprparent,oprentryentity.oprno", (QFilter[])new QFilter[]{filter});
        techMap.put(orderKeys, manftechDym);
        return manftechDym;
    }

    public static BigDecimal getOrderBaseQty(Object orderEntryId, String orderName) {
        Map<String, Object> orderMap = MPDMMftGenStocksUtils.getOrderQtyMap(orderEntryId, orderName);
        if (orderMap.isEmpty()) {
            return BigDecimal.ONE;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        orderBaseQty = (BigDecimal)orderMap.get("baseqty");
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        return orderBaseQty;
    }

    public static BigDecimal aculWIPQty(DynamicObject stockEntry) {
        BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
        BigDecimal feedingQty = stockEntry.getBigDecimal("feedingqty");
        BigDecimal rejectedQty = stockEntry.getBigDecimal("rejectedqty");
        BigDecimal useQty = stockEntry.getBigDecimal("useqty");
        return actissueQty.add(feedingQty).subtract(rejectedQty).subtract(useQty);
    }

    public static Map<String, Object> getPmAppParameterMap(Long orgId, String stockName) {
        if (EntityNameUtils.getAllOmStockName().contains(stockName)) {
            AppParam appParam = new AppParam("1/OY+A2+47UY", orgId, Long.valueOf(0L));
            return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        }
        AppParam appParam = new AppParam("064+TL0DU6T9", orgId, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }
}

