/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.val;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.common.mdc.enums.OperateEnum;
import org.apache.commons.collections4.CollectionUtils;

public class MdcReturnApplyBillValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOperateKey();
        this.doValidate(operate);
    }

    private void doValidate(String operate) {
        HashSet<Long> mainBillIds = new HashSet<Long>(16);
        String mainbillentity = "";
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                Long mainBillId = entryObj.getLong("mainbillid");
                mainbillentity = entryObj.getString("mainbillentity");
                mainBillIds.add(mainBillId);
            }
        }
        if (mainBillIds.size() == 1 && mainBillIds.contains(0L)) {
            return;
        }
        Map<Object, Map<String, Object>> mftStock = MdcReturnApplyBillValidator.getMftStockByIds(mainBillIds, mainbillentity);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            boolean isProp = obj.containsProperty("materialtype") && "E".equalsIgnoreCase(obj.getString("materialtype"));
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                String format;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                Long mainBillId = entryObj.getLong("mainbillid");
                DynamicObject bdmaterial = entryObj.getDynamicObject("materielmasterid");
                if ("submit".equals(operate) || "audit".equals(operate)) {
                    String format2;
                    String mftstockName;
                    if (null != bdmaterial) {
                        DynamicObject org = obj.getDynamicObject("org");
                        QFilter mftmaterialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.parseLong(org.getPkValue().toString()));
                        mftmaterialFilter.and(new QFilter("masterid", "=", bdmaterial.get("id")));
                        mftmaterialFilter.and(new QFilter("enable", "=", (Object)"1"));
                        mftmaterialFilter.and(new QFilter("status", "=", (Object)"C"));
                        DynamicObject mftmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{mftmaterialFilter});
                        if (null == mftmaterial) {
                            String format3 = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u672a\u521b\u5efa\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6%2$s\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"MdcReturnApplyBillValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), entryObj.getInt("seq"), entryObj.getString("materialname"));
                            this.addErrorMessage(this.dataEntities[i], format3);
                            continue;
                        }
                    }
                    Map<String, Object> map = mftStock.get(mainBillId);
                    String string = mftstockName = isProp ? String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u7528\u6599\u6e05\u5355", (String)"MdcReturnApplyBillValidator_6", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]) : String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355", (String)"MdcReturnApplyBillValidator_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                    if (map == null) {
                        format2 = String.format(ResManager.loadKDString((String)"\u672a\u751f\u6210\u5bf9\u5e94\u7684%1$s\u3002", (String)"MdcReturnApplyBillValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), mftstockName);
                        this.addErrorMessage(this.dataEntities[i], format2);
                        continue;
                    }
                    if (mainBillId.equals(map.get("id")) && !"C".equals(map.get("billstatus"))) {
                        format2 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5bf9\u5e94\u7684%2$s\u672a\u5ba1\u6838\uff0c%3$s\u5931\u8d25\u3002", (String)"MdcReturnApplyBillValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), map.get("billno"), mftstockName, OperateEnum.getValue(operate));
                        this.addErrorMessage(this.dataEntities[i], format2);
                        continue;
                    }
                }
                if (entryObj.getBigDecimal("qty").compareTo(BigDecimal.ZERO) <= 0) {
                    format = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\u201c\u7533\u8bf7\u6570\u91cf\u201d\u3002", (String)"MdcReturnApplyBillValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), obj.get("billno"), entryObj.get("seq"));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                if (entryObj.getBigDecimal("auditqty").compareTo(BigDecimal.ZERO) > 0) continue;
                format = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\u201c\u6838\u51c6\u6570\u91cf\u201d\u3002", (String)"MdcReturnApplyBillValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), obj.get("billno"), entryObj.get("seq"));
                this.addErrorMessage(this.dataEntities[i], format);
            }
        }
    }

    public static Map<Object, Map<String, Object>> getMftStockByIds(Set<Long> mainBillIds, String mainbillentity) {
        HashMap<Object, Map<String, Object>> map = new HashMap<Object, Map<String, Object>>(mainBillIds.size());
        if (CollectionUtils.isEmpty(mainBillIds)) {
            return map;
        }
        String algoKey = "queryPomMftStock";
        QFilter filter = new QFilter("id", "in", mainBillIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)mainbillentity, (String)"id,billno,billstatus,transactiontypeid.producttype,transactiontypeid.isoffrequpdatestock", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map1 = new HashMap<String, Object>(16);
                map1.put("id", row.getLong("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map.put(row.getLong("id"), map1);
            }
        }
        return map;
    }
}

