/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.adjustbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.im.business.helper.acct.BalanceHelper;
import kd.scmc.im.consts.InvBillConst;
import kd.scmc.im.errorcode.InvBaseErrorCode;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.opplugin.tpl.BillTplUnAuditOp;
import kd.scmc.im.validator.adjustbill.AdjustBillUnAuditValidator;
import kd.scmc.im.validator.plugin.TransFormBillValidatorPlugin;

public class AdjustBillUnAuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(BillTplUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        InvBillConst.getSelectorListForAcc().forEach(field -> e.getFieldKeys().add(field));
        AdjustBillUnAuditOp.getSubEntryList().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.afterentity.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        TransFormBillValidatorPlugin tplValidator = new TransFormBillValidatorPlugin(e, "unaudit", this.billEntityType.getName());
        tplValidator.validate();
        e.addValidator((AbstractValidator)new AdjustBillUnAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] invBills = e.getDataEntities();
        if (invBills == null || invBills.length == 0) {
            throw new KDBizException(InvBaseErrorCode.getBILL_NOT_EXISTS(), new Object[0]);
        }
        String formId = this.billEntityType.getName();
        ArrayList<Long> pks = new ArrayList<Long>(invBills.length);
        for (int i = 0; i < invBills.length; ++i) {
            pks.add(invBills[i].getLong("id"));
        }
        BalanceHelper.unAuditBalanceUpdate((String)formId, pks);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operate = (String)this.operateMeta.get("type");
        String formId = this.billEntityType.getName();
        TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
        triggerEventHelper.triggerEventByOp(e.getDataEntities(), operate, formId, this.getOption());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> delObjList = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : dataEntities) {
            if (!"210".equals(dataEntity.get("biztype"))) continue;
            delObjList.add(dataEntity);
        }
        if (!delObjList.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"im_adjustbill", (Object[])delObjList.toArray(), (OperateOption)OperateOption.create());
        }
    }

    public static List<String> getSubEntryList() {
        List<String> selectors = Arrays.asList("ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "warehouse", "location", "lot", "lotnumber", "producedate", "expirydate", "project", "baseunit", "baseqty", "qty", "unit2nd", "qtyunit2nd", "entrycomment");
        selectors.forEach(field -> selectors.set(selectors.indexOf(field), field + "1"));
        return selectors;
    }
}

