/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.assembbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.consts.InvBillConst;
import kd.scmc.im.opplugin.tpl.BillTplUnAuditOp;

public abstract class AbstractAssembBillOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(BillTplUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        InvBillConst.getSelectorListForAcc().forEach(field -> e.getFieldKeys().add(field));
        AbstractAssembBillOp.getSubEntryList().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.afterentity.seq");
    }

    public static List<String> getEntryList() {
        List<String> selectors = Arrays.asList("ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "warehouse", "location", "lot", "lotnumber", "producedate", "expirydate", "project", "baseunit", "baseqty", "qty", "unit2nd", "qtyunit2nd", "processingfee", "ecostcenter", "entrycomment");
        return selectors;
    }

    public static List<String> getSubEntryList() {
        List<String> selectors = Arrays.asList("ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "warehouse", "location", "lot", "lotnumber", "producedate", "expirydate", "project", "baseunit", "baseqty", "qty", "unit2nd", "qtyunit2nd", "entrycomment");
        selectors.forEach(field -> selectors.set(selectors.indexOf(field), field + "1"));
        ArrayList<String> b = new ArrayList<String>(selectors);
        b.add("usagerate");
        return b;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"AbstractAssembBillOp", (String)"beginOperationTransaction");){
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities.length == 0) {
                return;
            }
            MainEntityType dataEntityType = (MainEntityType)dataEntities[0].getDataEntityType();
            IDataEntityProperty bookDateProp = dataEntityType.findProperty("bookdate");
            for (DynamicObject dataEntity : dataEntities) {
                if (bookDateProp == null) continue;
                this.updateBookDate(dataEntity, bookDateProp);
            }
        }
    }

    private void updateBookDate(DynamicObject data, IDataEntityProperty bookDateProp) {
        Date bookDate = data.getDate(bookDateProp);
        if (bookDate == null) {
            data.set("bookdate", (Object)data.getDate("biztime"));
        }
    }
}

