/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.balanceinv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.scmc.operation.entryrowop.model.EntryRowOpArgs;
import kd.bos.ext.scmc.plugin.operation.IEntryRowOpFormPlugin;
import kd.bos.form.IFormView;

public class BalanceInvSplitRowOp
implements IEntryRowOpFormPlugin {
    private Integer unitPrecision = 10;

    public void calQtyTypeFields(EntryRowOpArgs args) {
        this.splitQtyFields(args, "adviseqty", "baseqty", "remaininbaseqty");
    }

    private void splitQtyFields(EntryRowOpArgs args, String ... qtyFields) {
        IFormView billView = args.getView();
        IDataModel model = billView.getModel();
        String entryKey = args.getEntryKey();
        Integer srcRowIndex = args.getSrcRowIndex();
        List newRowIndex = args.getNewRowIndex();
        DynamicObject entry = model.getEntryRowEntity(entryKey, srcRowIndex.intValue());
        for (String qtyField : qtyFields) {
            BigDecimal srcQty = entry.getBigDecimal(qtyField);
            int rowCount = newRowIndex.size() + 1;
            HashMap<Integer, BigDecimal> rowQtyMap = new HashMap<Integer, BigDecimal>(rowCount);
            DynamicObject unit = entry.getDynamicObject("baseunit");
            if (unit != null) {
                this.unitPrecision = unit.getInt("precision");
            }
            BigDecimal average = srcQty.divide(new BigDecimal(rowCount), (int)this.unitPrecision, RoundingMode.DOWN);
            BigDecimal multiply = average.multiply(new BigDecimal(newRowIndex.size()));
            BigDecimal lastRowQty = srcQty.subtract(multiply);
            rowQtyMap.put(srcRowIndex, average);
            for (int i = 0; i < newRowIndex.size() - 1; ++i) {
                rowQtyMap.put((Integer)newRowIndex.get(i), average);
            }
            rowQtyMap.put((Integer)newRowIndex.get(newRowIndex.size() - 1), lastRowQty);
            for (Map.Entry qtyEntry : rowQtyMap.entrySet()) {
                Integer rowIndex = (Integer)qtyEntry.getKey();
                BigDecimal qtyValue = (BigDecimal)qtyEntry.getValue();
                model.setValue(qtyField, (Object)qtyValue, rowIndex.intValue());
            }
        }
    }
}

