/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.balanceinv.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BalanceAdviseDeleteValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>();
        selectors.add("advicetype");
        selectors.add("supplyorg");
        selectors.add("supplier");
        selectors.add("billno");
        selectors.add("entryentity.isclosed");
        selectors.add("entryentity.iscancel");
        selectors.add("entryentity.supplyinvorg");
        selectors.add("entryentity.supplywarehouse");
        selectors.add("entryentity.seq");
        return selectors;
    }

    public void validate() {
        HashSet<Long> billIds = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            billIds.add(dataEntity.getDataEntity().getLong("id"));
        }
        String selectProperties = "bill_id,billentry_id,bal_id,bal_entryid";
        QFilter billIdFilter = new QFilter("bill_id", "in", billIds).or(new QFilter("bal_id", "in", billIds));
        DynamicObjectCollection reserveRecords = QueryServiceHelper.query((String)"msmod_reserve_record", (String)selectProperties, (QFilter[])billIdFilter.toArray());
        HashSet<Long> reserveBillIds = new HashSet<Long>();
        HashSet<Long> reserveEntryIds = new HashSet<Long>();
        for (DynamicObject reserveRecord : reserveRecords) {
            reserveBillIds.add(reserveRecord.getLong("bill_id"));
            reserveBillIds.add(reserveRecord.getLong("bal_id"));
            reserveEntryIds.add(reserveRecord.getLong("billentry_id"));
            reserveEntryIds.add(reserveRecord.getLong("bal_entryid"));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String adviceType;
            DynamicObject invBill = dataEntity.getDataEntity();
            if (!reserveBillIds.contains(invBill.getLong("id")) || "A".equals(adviceType = invBill.getString("advicetype")) || "F".equals(adviceType)) continue;
            DynamicObject supplyOrg = invBill.getDynamicObject("supplyorg");
            DynamicObject supplier = invBill.getDynamicObject("supplier");
            String billNo = invBill.getString("billno");
            if (supplyOrg == null && supplier == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e%s\u7684\u4f9b\u5e94\u7ec4\u7ec7\u548c\u4f9b\u5e94\u5546\u540c\u65f6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u91ca\u653e\u9884\u7559\u3002", (String)"BalanceAdviseDeleteValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), billNo));
            }
            DynamicObjectCollection billEntry = invBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : billEntry) {
                DynamicObject supplyWareHouse;
                String isClosed = entry.getString("isclosed");
                String isCancel = entry.getString("iscancel");
                if ("B".equals(isClosed) || "B".equals(isCancel) || !reserveEntryIds.contains(entry.getLong("id"))) continue;
                DynamicObject supplyInvOrg = entry.getDynamicObject("supplyinvorg");
                int seq = entry.getInt("seq");
                if (supplyInvOrg == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e%1$s\u7684\u5206\u5f55\u884c\u7b2c%2$s\u884c\u4f9b\u5e94\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u91ca\u653e\u9884\u7559\u3002", (String)"BalanceAdviseDeleteValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), billNo, seq));
                }
                if ((supplyWareHouse = entry.getDynamicObject("supplywarehouse")) != null) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e%1$s\u7684\u5206\u5f55\u884c\u7b2c%2$s\u884c\u4f9b\u5e94\u4ed3\u5e93\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u91ca\u653e\u9884\u7559\u3002", (String)"BalanceAdviseDeleteValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), billNo, seq));
            }
        }
    }
}

