/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.count;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.scmc.im.extpoint.IInvCountSchemeAuditExpand;

public class InvCountSchemeAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Arrays.asList("countzeroinv", "dimension", "dimensionentity", "defaultvalue", "counttype", "schemename", "warehouse", "location", "material", "backupcondition", "enddate", "filterstring_tag", "completestatus", "enablecheck", "accessnode", "excludeenddate", "nogenotherinout", "mulorg"));
        Map<String, String> fieldMap = this.getFieldMap();
        Set<String> countSchemeExpandKeys = fieldMap.keySet();
        fieldKeys.addAll(countSchemeExpandKeys);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] invCountSchemeObjs;
        super.beginOperationTransaction(e);
        boolean codeExist = this.invcountBillCodeRuleIsExist();
        if (!codeExist) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f00\u542f\u76d8\u70b9\u8868\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"InvCountSchemeAuditOp_11", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        for (DynamicObject dataEntity : invCountSchemeObjs = e.getDataEntities()) {
            ArrayList<String> businessInfos = new ArrayList<String>(1);
            long id = dataEntity.getLong("id");
            businessInfos.add(String.valueOf(id));
            CommonParam param = new CommonParam();
            param.put((Object)"id", (Object)id);
            this.createSession(businessInfos, param);
        }
    }

    private void createSession(List<String> businessInfos, CommonParam param) {
        ECGlobalSession.begin((String)"im_invcountsche_audit", (DBRoute)DBRoute.of((String)"scm"), (Propagation)Propagation.REQUIRES_NEW);
        ECGlobalSession.setBusinessType((String)"im_invcountsche_audit");
        ECGlobalSession.setBusinessInfo(businessInfos);
        ECGlobalSession.register((String)"scmc", (String)"im", (String)"InvCountSchemeAuditService", (Param)param, null);
        ECGlobalSession.setAsync((boolean)Boolean.TRUE);
    }

    private boolean invcountBillCodeRuleIsExist() {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject invCountObj = BusinessDataServiceHelper.newDynamicObject((String)"im_invcountbill");
        return codeRuleService.isExist("im_invcountbill", invCountObj, "");
    }

    private Map<String, String> getFieldMap() {
        PluginProxy proxyPlugins = PluginProxy.create(IInvCountSchemeAuditExpand.class, (String)"SCMC_IM_INV_COUNTSCHEMEAUDIT");
        List plugins = proxyPlugins.getPlugins();
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        for (IInvCountSchemeAuditExpand plugin : plugins) {
            fieldMap.putAll(plugin.getFieldMap());
        }
        return fieldMap;
    }
}

