/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.count;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.business.helper.DymAccDataSourceHelper;
import kd.scmc.im.business.helper.InvcountSchemeHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.consts.InvCountSchemeConst;
import kd.scmc.im.opplugin.count.DymAccDataSource;
import kd.scmc.im.utils.DateUtils;

public class InvCountSchemeEndDateInvAccQuery {
    public static DataSet handleEndDateInvAccToInvCountOp(DynamicObject invCountSchemeObj, Set<QFilter> setQFilter) {
        ArrayList<QFilter> listInvBalanceQFilter = new ArrayList<QFilter>(setQFilter.size());
        for (QFilter qFilter : setQFilter) {
            listInvBalanceQFilter.add(qFilter.copy());
        }
        QFilter billDateFilter = InvcountSchemeHelper.getBillDateFilter((DynamicObject)invCountSchemeObj);
        setQFilter.add(billDateFilter);
        DataSet billDataSetFromBeforeEndDate = DymAccDataSource.getBeforeEndDateUpdateBill(setQFilter);
        String[] balanceUpdateKeys = null;
        balanceUpdateKeys = "im_invacc".equals(InvAccConst.getBalTb()) ? InvCountSchemeConst.getInvbalanceDimensionField() : (String[])DymAccDataSourceHelper.getBalanceUpdateKeys().get();
        DataSet dataSet = InvCountSchemeEndDateInvAccQuery.getBeforeEndDateInvQty(listInvBalanceQFilter, invCountSchemeObj, billDataSetFromBeforeEndDate, balanceUpdateKeys);
        String[] dataSetFiledsExcludeBgn = InvcountSchemeHelper.removeFiled((String[])InvcountSchemeHelper.getDataSetFieldArray((DataSet)dataSet), (String[])InvCountSchemeEndDateInvAccQuery.getBgnQtyField());
        dataSet = dataSet.select(InvcountSchemeHelper.arraysToString((String[])InvcountSchemeHelper.addFileds((String[])dataSetFiledsExcludeBgn, (String[])new String[]{"bgnqty as qty", "bgnbaseqty as baseqty", "bgnqty2nd as qtyunit2nd"})));
        return dataSet;
    }

    private static DataSet getBeforeEndDateInvQty(List<QFilter> listInvBalanceQFilter, DynamicObject invCountSchemeObj, DataSet billDataSetFromBeforeEndDate, String[] balanceUpdateKeys) {
        DataSet invBalanceDataSet = InvCountSchemeEndDateInvAccQuery.getInvBalanceDataSet(listInvBalanceQFilter, invCountSchemeObj, balanceUpdateKeys);
        String[] invBalanceField = InvcountSchemeHelper.getDataSetFieldArray((DataSet)invBalanceDataSet);
        if (invBalanceDataSet.copy().isEmpty()) {
            invBalanceDataSet = InvcountSchemeHelper.addSumColumn((GroupbyDataSet)billDataSetFromBeforeEndDate.groupBy(InvcountSchemeHelper.removeFiled((String[])invBalanceField, (String[])new String[]{"bgnqty", "bgnbaseqty", "bgnqty2nd", "endperiod"})), (String[])InvCountSchemeConst.getRecandsendfield()).finish();
            HashMap<String, String> mapperbgn = new HashMap<String, String>();
            mapperbgn.put("bgnqty", "inqty - outqty");
            mapperbgn.put("bgnbaseqty", "inbaseqty - outbaseqty");
            mapperbgn.put("bgnqty2nd", "inqty2nd - outqty2nd");
            invBalanceDataSet = InvcountSchemeHelper.handleNullFiledAsZero((DataSet)invBalanceDataSet, (String[])InvCountSchemeConst.getRecandsendfield());
            invBalanceDataSet = invBalanceDataSet.select(InvcountSchemeHelper.mapperFileds((String[])InvcountSchemeHelper.removeFiled((String[])invBalanceField, (String[])new String[]{"endperiod"}), mapperbgn, (String[])new String[0]));
            return invBalanceDataSet;
        }
        DataSet invBalanceToStartDateBillDataSet = InvcountSchemeHelper.addJoinColumn((JoinDataSet)billDataSetFromBeforeEndDate.copy().leftJoin(invBalanceDataSet.copy()), (String[])balanceUpdateKeys).select(billDataSetFromBeforeEndDate.getRowMeta().getFieldNames(), new String[]{"0 as bgnqty", "0 as bgnbaseqty", "0 as bgnqty2nd"}).finish().select(InvcountSchemeHelper.addFileds((String[])InvcountSchemeHelper.addFileds((String[])balanceUpdateKeys, (String[])InvCountSchemeConst.getRecandsendfield()), (String[])new String[]{"bgnqty", "bgnbaseqty", "bgnqty2nd", "biztime"})).removeFields(new String[]{"biztime"});
        invBalanceDataSet = invBalanceDataSet.select(InvcountSchemeHelper.addFileds((String[])balanceUpdateKeys, (String[])InvCountSchemeConst.getBalrecAndSendfield()));
        invBalanceDataSet = invBalanceToStartDateBillDataSet.union(invBalanceDataSet);
        HashMap<String, String> mapperbgn = new HashMap<String, String>();
        mapperbgn.put("bgnqty", "(bgnqty + inqty) - outqty");
        mapperbgn.put("bgnbaseqty", "(bgnbaseqty + inbaseqty) - outbaseqty");
        mapperbgn.put("bgnqty2nd", "(bgnqty2nd + inqty2nd) - outqty2nd");
        invBalanceDataSet = InvcountSchemeHelper.handleNullFiledAsZero((DataSet)invBalanceDataSet, (String[])InvCountSchemeConst.getRecandsendfield()).select(invBalanceDataSet.getRowMeta().getFieldNames());
        invBalanceDataSet = invBalanceDataSet.select(InvcountSchemeHelper.mapperFileds((String[])invBalanceDataSet.getRowMeta().getFieldNames(), mapperbgn, (String[])new String[0]));
        invBalanceDataSet = InvcountSchemeHelper.addSumColumn((GroupbyDataSet)invBalanceDataSet.groupBy(balanceUpdateKeys), (String[])InvCountSchemeEndDateInvAccQuery.getBgnQtyField()).finish();
        return invBalanceDataSet;
    }

    private static DataSet getInvBalanceDataSet(List<QFilter> listQFilter, DynamicObject invCountSchemeObj, String[] balanceUpdateKeys) {
        Date endDate = invCountSchemeObj.getDate("enddate");
        String accessNode = invCountSchemeObj.getString("accessnode");
        if ("end".equals(accessNode)) {
            endDate = DateUtils.addOneDay((Date)endDate);
        }
        ArrayList<QFilter> listFinalQFilter = new ArrayList<QFilter>();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        Integer startTime = Integer.valueOf(format.format(endDate));
        listFinalQFilter.add(new QFilter("endperiod", ">=", (Object)startTime).and("period", "<", (Object)startTime));
        listFinalQFilter.addAll(listQFilter);
        if (!BalanceUpdateHandle.isNewPeriodBal()) {
            listFinalQFilter.add(new QFilter("balancetype", "=", (Object)Character.valueOf('1')));
        }
        for (QFilter qFilter : listFinalQFilter) {
            if (!"lotnum".equals(qFilter.getProperty())) continue;
            qFilter.__setProperty("lotnumber");
        }
        String[] InvBalanceSelectFileds = InvcountSchemeHelper.addFileds((String[])InvcountSchemeHelper.addFileds((String[])balanceUpdateKeys, (String[])InvcountSchemeHelper.getInvBalacneEndQtyFieldAsBgnQty()), (String[])new String[]{"endperiod"});
        String entityInvbalance = "im_invbalance";
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            entityInvbalance = "im_inv_periodbalance";
        }
        DataSet invBalance = QueryServiceHelper.queryDataSet((String)InvCountSchemeEndDateInvAccQuery.class.getClass().getName(), (String)entityInvbalance, (String)InvcountSchemeHelper.arraysToString((String[])InvBalanceSelectFileds), (QFilter[])listFinalQFilter.toArray(new QFilter[listFinalQFilter.size()]), (String)"");
        invBalance = invBalance.select(InvcountSchemeHelper.addFileds((String[])balanceUpdateKeys, (String[])InvCountSchemeEndDateInvAccQuery.getBgnQtyField()));
        return invBalance;
    }

    private static String[] getBgnQtyField() {
        return new String[]{"bgnqty", "bgnbaseqty", "bgnqty2nd"};
    }
}

