/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.importop;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.enums.InvalidEnum;

public class InvOperatorMatImportOp
extends BatchImportPlugin {
    private Map<String, Long> orgCache = new HashMap<String, Long>();
    private Map<String, List<Long>> orgGroupListMap = new HashMap<String, List<Long>>();
    private Map<Long, QFilter> matBaseDataFilterMap = new HashMap<Long, QFilter>(16);
    private Map<Long, QFilter> matGroupBaseDataFilterMap = new HashMap<Long, QFilter>(16);
    private Map<Long, QFilter> operatorGroupBaseDataFilterMap = new HashMap<Long, QFilter>(16);
    private HashSet<String> hasPermissionOrgSet;
    private List<Long> userInvalidGrpList;
    private Map<Long, Map<String, Long>> orgOperatorGroupMap = new HashMap<Long, Map<String, Long>>(16);
    private Map<String, Map<Long, DynamicObject>> operatorCache = new HashMap<String, Map<Long, DynamicObject>>(16);

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (rowdatas.isEmpty()) {
            return null;
        }
        this.cacheBaseData(rowdatas);
        this.beforeImportBill(rowdatas, logger);
        return super.save(rowdatas, logger);
    }

    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        this.hasPermissionOrgSet = this.getHasPermissionOrgSet();
        long currUserId = RequestContext.get().getCurrUserId();
        this.userInvalidGrpList = InvOperatorMatImportOp.getOperatorGroupByUser(currUserId, true);
        while (iterator.hasNext()) {
            this.checkData(logger, iterator);
        }
    }

    private void checkData(ImportLogger logger, Iterator<ImportBillData> iterator) {
        Map deptMap;
        QFilter baseDataFilter;
        Map operatorMap;
        ImportBillData rowData = iterator.next();
        int index = rowData.getStartIndex();
        JSONObject data = rowData.getData();
        this.clearDataByControlDimension(data);
        Map orgMap = (Map)data.get((Object)"org");
        boolean checkOrg = this.checkOrg(logger, orgMap, index);
        if (!checkOrg) {
            iterator.remove();
            return;
        }
        String controlDimension = data.getString("controldimension");
        String orgNum = (String)orgMap.get("number");
        Long orgId = this.orgCache.get(orgNum);
        List<Long> haveOrgGroupList = this.orgGroupListMap.get(orgNum);
        if (("OPER_MATER".equals(controlDimension) || "OPER_MATERGRP".equals(controlDimension)) && ((operatorMap = (Map)data.get((Object)"operator")) == null || StringUtils.isBlank(operatorMap.get("operatornumber")))) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u7ba1\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvOperatorMatImportOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
            iterator.remove();
            return;
        }
        if ("OPERGRP_MATERGRP".equals(controlDimension) || "OPERGRP_MATER".equals(controlDimension) || "OPER_MATER".equals(controlDimension) || "OPER_MATERGRP".equals(controlDimension)) {
            Map operatorGroupMap = (Map)data.get((Object)"operatorgroup");
            if (operatorGroupMap == null || StringUtils.isBlank(operatorGroupMap.get("number"))) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u7ba1\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvOperatorMatImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return;
            }
            Object groupNumber = operatorGroupMap.get("number");
            Map<String, Long> groupMap = this.cacheOperatorGroup(orgId);
            if (!groupMap.containsKey(groupNumber) || !haveOrgGroupList.contains(groupMap.get(groupNumber))) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6ca1\u6709\u7f16\u7801\u4e3a%s\u7684\u5e93\u7ba1\u7ec4\u6743\u9650\u3002", (String)"InvOperatorMatImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[]{groupNumber})).fail();
                iterator.remove();
                return;
            }
            if ("OPER_MATER".equals(controlDimension) || "OPER_MATERGRP".equals(controlDimension)) {
                Map operatorMap2 = (Map)data.get((Object)"operator");
                String operatorNumber = (String)operatorMap2.get("operatornumber");
                Map<Long, DynamicObject> grpIdToOperatorMap = this.operatorCache.get(operatorNumber);
                if (grpIdToOperatorMap == null || grpIdToOperatorMap.get(groupMap.get(groupNumber)) == null) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u7ba1\u5458\u5728\u8be5\u5e93\u7ba1\u7ec4\u4e0b\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548\u3002", (String)"InvOperatorMatImportOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
                    iterator.remove();
                    return;
                }
                DynamicObject operatorDyn = grpIdToOperatorMap.get(groupMap.get(groupNumber));
                operatorMap2.put("id", operatorDyn.getPkValue());
            }
        }
        if ("OPER_MATER".equals(controlDimension) || "DEPT_MATER".equals(controlDimension) || "OPERGRP_MATER".equals(controlDimension)) {
            Map materialMap = (Map)data.get((Object)"material");
            if (materialMap == null || StringUtils.isBlank(materialMap.get("number"))) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvOperatorMatImportOp_4", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return;
            }
            String materialNum = (String)materialMap.get("number");
            QFilter materialQ = new QFilter("number", "=", (Object)materialNum);
            Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])materialQ.and(baseDataFilter = this.cacheBaseDataFilter(orgId, "bd_material", this.matBaseDataFilterMap)).toArray());
            if (materials == null || materials.isEmpty()) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"DefaultWarehouseImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[]{materialNum})).fail();
                iterator.remove();
                return;
            }
        }
        if ("OPERGRP_MATERGRP".equals(controlDimension) || "OPER_MATERGRP".equals(controlDimension) || "DEPT_MATERGRP".equals(controlDimension)) {
            Map materialGroupMap = (Map)data.get((Object)"materialgroup");
            if (materialGroupMap == null || StringUtils.isBlank(materialGroupMap.get("number"))) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvOperatorMatImportOp_5", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return;
            }
            String grpNumber = (String)materialGroupMap.get("number");
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and("number", "=", (Object)grpNumber);
            baseDataFilter = this.cacheBaseDataFilter(orgId, "bd_materialgroup", this.matGroupBaseDataFilterMap);
            qFilter.and(baseDataFilter);
            Map groupMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"number", (QFilter[])qFilter.toArray());
            if (groupMap == null || groupMap.isEmpty()) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"DefaultWarehouseImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[]{grpNumber})).fail();
                iterator.remove();
                return;
            }
        }
        if (("DEPT_MATER".equals(controlDimension) || "DEPT_MATERGRP".equals(controlDimension)) && ((deptMap = (Map)data.get((Object)"dept")) == null || StringUtils.isBlank(deptMap.get("number")))) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u7ba1\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvOperatorMatImportOp_6", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
            iterator.remove();
            return;
        }
    }

    private Map<String, Long> cacheOperatorGroup(Long orgId) {
        HashMap<String, Long> groupMap = new HashMap(16);
        if (this.orgOperatorGroupMap.containsKey(orgId)) {
            groupMap = this.orgOperatorGroupMap.get(orgId);
        } else {
            QFilter[] qFilters = this.getQFilter(orgId);
            Map groupObjMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,number", (QFilter[])qFilters);
            for (DynamicObject groupObj : groupObjMap.values()) {
                groupMap.put(groupObj.getString("number"), groupObj.getLong("id"));
            }
            this.orgOperatorGroupMap.put(orgId, groupMap);
        }
        return groupMap;
    }

    private boolean checkOrg(ImportLogger logger, Map<String, Object> orgMap, Integer index) {
        if (orgMap == null || StringUtils.isBlank((Object)orgMap.get("number"))) {
            logger.log(index, ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WarehouseSetupImportOp_6", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
            return false;
        }
        String orgNum = (String)orgMap.get("number");
        Long orgId = this.orgCache.get(orgNum);
        if (orgId == null) {
            logger.log(index, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"WarehouseSetupImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[]{orgNum})).fail();
            return false;
        }
        List<Long> haveOrgGroupList = this.orgGroupListMap.get(orgNum);
        if (haveOrgGroupList == null || haveOrgGroupList.isEmpty()) {
            haveOrgGroupList = this.getOperatorGroupByOrg(orgId, this.userInvalidGrpList);
            this.orgGroupListMap.put(orgNum, haveOrgGroupList);
        }
        if (!this.hasPermissionOrgSet.contains(orgNum)) {
            logger.log(index, ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u65e0\u6743\u9650\u6216\u975e\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"WarehouseSetupImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[]{orgNum})).fail();
            return false;
        }
        return true;
    }

    private List<Long> getOperatorGroupByOrg(Long orgId, List<Long> userInvalidGrpList) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>(16);
        QFilter[] qFilters = this.getQFilter(orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])qFilters);
        if (map != null && map.size() > 0) {
            for (DynamicObject dynamicObject : map.values()) {
                if (dynamicObject == null) continue;
                operatorGroupList.add((Long)dynamicObject.getPkValue());
            }
        }
        if (userInvalidGrpList != null && !userInvalidGrpList.isEmpty()) {
            operatorGroupList.removeAll(userInvalidGrpList);
        }
        return operatorGroupList;
    }

    private QFilter[] getQFilter(Long orgId) {
        QFilter qFilter1 = this.cacheBaseDataFilter(orgId, "bd_operatorgroup", this.operatorGroupBaseDataFilterMap);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
        return new QFilter[]{qFilter1, qFilter2};
    }

    private QFilter cacheBaseDataFilter(Long orgId, String entity, Map<Long, QFilter> baseDataFilterMap) {
        QFilter baseDataFilter = null;
        if (baseDataFilterMap.containsKey(orgId)) {
            baseDataFilter = baseDataFilterMap.get(orgId);
        } else {
            baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)orgId);
            baseDataFilterMap.put(orgId, baseDataFilter);
        }
        return baseDataFilter;
    }

    private static List<Long> getOperatorGroupByUser(long userID, boolean invalid) {
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = new QFilter("operatorid", "=", (Object)userID);
        QFilter q2 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
        String invalidValue = InvalidEnum.NO.getValue();
        if (invalid) {
            invalidValue = InvalidEnum.YES.getValue();
        }
        q2.and("invalid", "=", (Object)invalidValue);
        DynamicObjectCollection operatorCollection = QueryServiceHelper.query((String)"bd_operator", (String)"id,operatorgrpid", (QFilter[])new QFilter[]{q1, q2});
        if (operatorCollection != null && operatorCollection.size() > 0) {
            operatorGroupList = new ArrayList<Long>(operatorCollection.size());
            for (DynamicObject operator : operatorCollection) {
                if (operator == null) continue;
                operatorGroupList.add(operator.getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }

    protected void cacheBaseData(List<ImportBillData> rowDatas) {
        Iterator<ImportBillData> iterator = rowDatas.iterator();
        HashSet<DynamicObject[]> orgNumberList = new HashSet<DynamicObject[]>();
        HashSet<String> operatorNumberList = new HashSet<String>();
        while (iterator.hasNext()) {
            JSONObject data = iterator.next().getData();
            Map orgMap = (Map)data.get((Object)"org");
            if (orgMap == null || StringUtils.isBlank(orgMap.get("number"))) continue;
            DynamicObject[] orgNum = (DynamicObject[])orgMap.get("number");
            orgNumberList.add(orgNum);
            Map operatorMap = (Map)data.get((Object)"operator");
            if (operatorMap == null || StringUtils.isBlank(operatorMap.get("operatornumber"))) continue;
            String operatorNumber = (String)operatorMap.get("operatornumber");
            operatorNumberList.add(operatorNumber);
        }
        if (!orgNumberList.isEmpty()) {
            DynamicObject[] orgList;
            QFilter numberQ = new QFilter("number", "in", orgNumberList);
            for (DynamicObject org : orgList = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{numberQ})) {
                this.orgCache.put(org.getString("number"), (Long)org.getPkValue());
            }
        }
        if (!operatorNumberList.isEmpty()) {
            QFilter operatorNumberQ = new QFilter("operatornumber", "in", operatorNumberList);
            QFilter operatorInvalidQ = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            Map operatorMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"id,operatornumber,operatorgrpid", (QFilter[])operatorNumberQ.and(operatorInvalidQ).toArray());
            for (DynamicObject operator : operatorMap.values()) {
                Map<Object, Object> grpIdToOperatorMap;
                String operatorNumber = operator.getString("operatornumber");
                Long operatorGrpId = operator.getLong("operatorgrpid");
                if (this.operatorCache.containsKey(operatorNumber)) {
                    grpIdToOperatorMap = this.operatorCache.get(operatorNumber);
                    if (grpIdToOperatorMap.containsKey(operatorGrpId)) continue;
                    grpIdToOperatorMap.put(operatorGrpId, operator);
                    continue;
                }
                grpIdToOperatorMap = new HashMap<Long, DynamicObject>();
                grpIdToOperatorMap.put(operatorGrpId, operator);
                this.operatorCache.put(operatorNumber, grpIdToOperatorMap);
            }
        }
    }

    protected HashSet<String> getHasPermissionOrgSet() {
        HashSet<String> userToPermissionOrgSet = new HashSet<String>(16);
        List hasPermissionOrgList = NewInvOrgHelper.getPermissionOrgsByAppId((String)"im_invoperatormat", null);
        if (hasPermissionOrgList == null || hasPermissionOrgList.isEmpty()) {
            return userToPermissionOrgSet;
        }
        for (Map orgData : hasPermissionOrgList) {
            userToPermissionOrgSet.add((String)orgData.get("number"));
        }
        return userToPermissionOrgSet;
    }

    private void clearDataByControlDimension(JSONObject data) {
        String controlDimension;
        switch (controlDimension = data.getString("controldimension")) {
            case "OPER_MATER": {
                data.put("dept", null);
                data.put("materialgroup", null);
                return;
            }
            case "OPER_MATERGRP": {
                data.put("dept", null);
                data.put("material", null);
                return;
            }
            case "OPERGRP_MATER": {
                data.put("operator", null);
                data.put("dept", null);
                data.put("materialgroup", null);
                return;
            }
            case "OPERGRP_MATERGRP": {
                data.put("operator", null);
                data.put("dept", null);
                data.put("material", null);
                return;
            }
            case "DEPT_MATER": {
                data.put("operator", null);
                data.put("operatorgroup", null);
                data.put("materialgroup", null);
                return;
            }
            case "DEPT_MATERGRP": {
                data.put("operator", null);
                data.put("operatorgroup", null);
                data.put("material", null);
                return;
            }
        }
    }
}

