/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.importop;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;

public class WarehouseSetupImportOp
extends BatchImportPlugin {
    private Map<String, Map<String, DynamicObject>> materialDymOrgMap = new HashMap<String, Map<String, DynamicObject>>();
    private Map<String, List<QFilter>> orgAndBaseFilter = new HashMap<String, List<QFilter>>();
    private Set<Object> bizOperatorSet = new HashSet<Object>();
    private Map<String, List<String>> userToPermissOrgs = new HashMap<String, List<String>>(16);
    private Set<Object> wareHouses = new HashSet<Object>();

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.cacheBaseData(rowdatas, logger);
        this.beforeImportBill(rowdatas, logger);
        if (rowdatas.isEmpty()) {
            return null;
        }
        return super.save(rowdatas, logger);
    }

    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            this.handleRowData(logger, iterator);
        }
    }

    private void handleRowData(ImportLogger logger, Iterator<ImportBillData> iterator) {
        List listOperatorData;
        Map wareHouse;
        ImportBillData rowdata = iterator.next();
        int index = rowdata.getStartIndex();
        JSONObject data = rowdata.getData();
        data.put("enable", (Object)"1");
        Map orgMap = (Map)data.get((Object)"org");
        String orgNum = (String)orgMap.get("number");
        Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(orgNum);
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        List<String> hasPermissionOrgs = this.userToPermissOrgs.get(currUserId);
        Boolean hasPermission = Boolean.FALSE;
        for (String org : hasPermissionOrgs) {
            if (!orgNum.equals(org)) continue;
            hasPermission = Boolean.TRUE;
            break;
        }
        if (!hasPermission.booleanValue()) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u65e0\u6743\u9650\u6216\u975e\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"WarehouseSetupImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
            iterator.remove();
            return;
        }
        Boolean isallowpartialneginv = data.getBoolean("isallowpartialneginv");
        if (isallowpartialneginv != null && isallowpartialneginv.booleanValue()) {
            data.put("isallowallneginv", (Object)Boolean.FALSE);
        }
        if ((wareHouse = (Map)data.get((Object)"warehouse")) == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed3\u5e93\u4fe1\u606f\u3002", (String)"WarehouseSetupImportOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
            iterator.remove();
            return;
        }
        String wareHouseNum = (String)wareHouse.get("number");
        if (!this.wareHouses.contains(wareHouseNum)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u4ed3\u5e93\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u6216\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\u3002", (String)"WarehouseSetupImportOp_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), wareHouseNum)).fail();
            iterator.remove();
            return;
        }
        List listData = (List)data.get((Object)"materialentity");
        if (listData != null) {
            for (Map row : listData) {
                Map material = (Map)row.get("materialnumber");
                if (material == null) continue;
                String materialNum = (String)material.get("number");
                DynamicObject materialDym = materialDymMap.get(materialNum);
                if (materialDym == null) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"WarehouseSetupImportOp_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum)).fail();
                    iterator.remove();
                    return;
                }
                row.put("materialgrpnumber", null);
            }
        }
        if ((listOperatorData = (List)data.get((Object)"operatorentity")) == null) {
            return;
        }
        for (Map row : listOperatorData) {
            String operatorNum;
            Boolean operatorCheck;
            Map operator = (Map)row.get("operatoruser");
            if (operator == null || (operatorCheck = Boolean.valueOf(this.bizOperatorSet.contains(operatorNum = (String)operator.get(operator.getOrDefault("importprop", "number"))))).booleanValue()) continue;
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u4e1a\u52a1\u5458\u4e0d\u5b58\u5728\u6216\u4e0d\u4e3a\u5e93\u5b58\u7ec4\u7c7b\u578b\u7684\u4e1a\u52a1\u5458\u3002", (String)"WarehouseSetupImportOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), operatorNum)).fail();
            iterator.remove();
            return;
        }
    }

    protected void cacheBaseData(List<ImportBillData> rowdatas, ImportLogger logger) {
        HashMap<String, HashSet<String>> materialNumsMap = new HashMap<String, HashSet<String>>(16);
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        List<String> hasPermissionOrgs = this.userToPermissOrgs.get(currUserId);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            this.userToPermissOrgs = this.getHasPermissionOrgs();
            hasPermissionOrgs = this.userToPermissOrgs.get(currUserId);
        }
        while (iterator.hasNext()) {
            List listData;
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            int index = rowdata.getStartIndex();
            Map orgMap = (Map)data.get((Object)"org");
            if (orgMap == null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WarehouseSetupImportOp_6", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                continue;
            }
            String orgNum = (String)orgMap.get("number");
            if (StringUtils.isBlank((CharSequence)orgNum)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WarehouseSetupImportOp_6", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                continue;
            }
            Map<String, DynamicObject> materialCacheMap = this.materialDymOrgMap.get(orgNum);
            if (!this.orgAndBaseFilter.containsKey(orgNum)) {
                QFilter qFilter = new QFilter("number", "=", (Object)orgNum);
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])qFilter.toArray());
                if (org == null) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"WarehouseSetupImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), orgNum)).fail();
                    iterator.remove();
                    continue;
                }
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
                ArrayList<QFilter> orgAndFilter = new ArrayList<QFilter>();
                orgAndFilter.add(baseDataFilter);
                this.orgAndBaseFilter.put(orgNum, orgAndFilter);
            }
            if ((listData = (List)data.get((Object)"materialentity")) == null) continue;
            for (Map row : listData) {
                Map material = (Map)row.get("materialnumber");
                if (material == null) continue;
                String materialNum = (String)material.get("number");
                if (materialCacheMap != null && materialCacheMap.containsKey(materialNum)) continue;
                HashSet<String> materialNums = (HashSet<String>)materialNumsMap.get(orgNum);
                if (materialNums == null) {
                    materialNums = new HashSet<String>();
                    materialNumsMap.put(orgNum, materialNums);
                }
                materialNums.add(materialNum);
            }
        }
        if (materialNumsMap.size() > 0) {
            for (Map.Entry next : materialNumsMap.entrySet()) {
                String orgNum = (String)next.getKey();
                if (this.materialDymOrgMap.get(orgNum) != null) continue;
                Set materialNums = (Set)next.getValue();
                List<QFilter> orgAndFilter = this.orgAndBaseFilter.get(orgNum);
                if (orgAndFilter == null) continue;
                QFilter baseDataFilter = orgAndFilter.get(0);
                baseDataFilter.and(new QFilter("masterid.number", "in", (Object)materialNums));
                Map materialDymLoad = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])baseDataFilter.toArray());
                Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(orgNum);
                if (materialDymMap == null) {
                    materialDymMap = new HashMap<String, DynamicObject>(16);
                    this.materialDymOrgMap.put(orgNum, materialDymMap);
                }
                for (DynamicObject materialDym : materialDymLoad.values()) {
                    materialDymMap.put(materialDym.getString("masterid.number"), materialDym);
                }
            }
        }
        this.cache4BizOperator();
        this.cacheWareHouses();
    }

    protected void cache4BizOperator() {
        QFilter opergrpFilter = new QFilter("operatorgrouptype", "=", (Object)"KCZ");
        Map bizOperators = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,entryentity.operator", (QFilter[])opergrpFilter.toArray());
        for (DynamicObject bizOperator : bizOperators.values()) {
            DynamicObjectCollection operatorNum = bizOperator.getDynamicObjectCollection("entryentity");
            for (DynamicObject dy : operatorNum) {
                DynamicObject operator = dy.getDynamicObject("operator");
                if (operator == null) continue;
                String number = operator.getString("number");
                this.bizOperatorSet.add(number);
            }
        }
    }

    protected void cacheWareHouses() {
        QFilter wareHouseFilter = new QFilter("status", "=", (Object)"C");
        wareHouseFilter.and(new QFilter("enable", "=", (Object)"1"));
        Map bizWareHouses = BusinessDataServiceHelper.loadFromCache((String)"bd_warehouse", (String)"number", (QFilter[])wareHouseFilter.toArray());
        for (DynamicObject bizWareHouse : bizWareHouses.values()) {
            if (bizWareHouse == null) continue;
            String wareHouseNum = bizWareHouse.getString("number");
            this.wareHouses.add(wareHouseNum);
        }
    }

    protected Map<String, List<String>> getHasPermissionOrgs() {
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        HashMap<String, List<String>> userToPermissOrgs = new HashMap<String, List<String>>(16);
        List hasPermissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId((String)"im_warehousesetup", null);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            userToPermissOrgs.put(currUserId, new ArrayList(10));
            return userToPermissOrgs;
        }
        for (Map orgData : hasPermissionOrgs) {
            if (!userToPermissOrgs.containsKey(currUserId)) {
                userToPermissOrgs.put(currUserId, new ArrayList(10));
            }
            ((List)userToPermissOrgs.get(currUserId)).add(orgData.get("number"));
        }
        return userToPermissOrgs;
    }
}

