/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.importop.basesetting;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import org.apache.commons.collections.CollectionUtils;

public class DefaultWarehouseImportOp
extends BatchImportPlugin {
    private static final String SCMC_IM_OPPLUGIN = "scmc-im-opplugin";
    private final Map<String, Map<String, DynamicObject>> materialDymOrgMap = new HashMap<String, Map<String, DynamicObject>>(16);
    private final Set<String> materielGrps = new HashSet<String>(16);
    private final Map<String, Map<DynamicObject, QFilter>> orgAndBaseFilter = new HashMap<String, Map<DynamicObject, QFilter>>();
    private Map<String, Set<String>> userToPermissOrgs = new HashMap<String, Set<String>>(16);

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        try (TraceSpan span = Tracer.create((String)"DefaultWarehouseImportOp", (String)"cacheBaseData");){
            this.cacheBaseData(rowdatas, logger);
        }
        span = Tracer.create((String)"DefaultWarehouseImportOp", (String)"beforeImportBill");
        var4_4 = null;
        try {
            this.beforeImportBill(rowdatas, logger);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (span != null) {
                if (var4_4 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    span.close();
                }
            }
        }
        if (rowdatas == null || rowdatas.isEmpty()) {
            return null;
        }
        return super.save(rowdatas, logger);
    }

    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            this.handleRowData(logger, iterator);
        }
    }

    private void handleRowData(ImportLogger logger, Iterator<ImportBillData> iterator) {
        ImportBillData row = iterator.next();
        int index = row.getStartIndex();
        JSONObject data = row.getData();
        Map orgMap = (Map)data.get((Object)"org");
        String orgNum = (String)orgMap.get("number");
        Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(orgNum);
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        Set<String> hasPermissionOrgs = this.userToPermissOrgs.get(currUserId);
        if (!hasPermissionOrgs.contains(orgNum)) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u65e0\u6743\u9650\u3002", (String)"DefaultWarehouseImportOp_0", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0])).fail();
            iterator.remove();
            return;
        }
        Map material = (Map)data.get((Object)"materialnumber");
        if (material != null) {
            String materialNum = (String)material.get("number");
            DynamicObject materialDym = materialDymMap.get(materialNum);
            if (materialDym == null) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"DefaultWarehouseImportOp_1", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0]), materialNum)).fail();
                iterator.remove();
                return;
            }
            material.put("id", materialDym.getPkValue());
        } else {
            String materialGrpNum;
            Map materialGrp = (Map)data.get((Object)"materialgrpnumber");
            if (materialGrp != null && !this.materielGrps.contains(materialGrpNum = (String)materialGrp.get("number"))) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"DefaultWarehouseImportOp_2", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0]), materialGrpNum)).fail();
                iterator.remove();
                return;
            }
        }
    }

    private void cacheBaseData(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        Set<String> hasPermissionOrgs = this.userToPermissOrgs.get(currUserId);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            this.userToPermissOrgs = this.getHasPermissionOrgs();
        }
        Map<String, Set<Object>> materialNumsMap = this.cacheOrg(logger, iterator);
        this.cacheMateriel(materialNumsMap);
        this.cacheMaterielGrp();
    }

    private void cacheMaterielGrp() {
        if (CollectionUtils.isEmpty(this.materielGrps)) {
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("number", "in", this.materielGrps);
        Map grps = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"number", (QFilter[])qFilter.toArray());
        this.materielGrps.clear();
        this.materielGrps.addAll(grps.values().stream().map(item -> item.getString("number")).collect(Collectors.toSet()));
    }

    private Map<String, Set<Object>> cacheOrg(ImportLogger logger, Iterator<ImportBillData> iterator) {
        HashMap<String, Set<Object>> materialNumsMap = new HashMap<String, Set<Object>>(16);
        while (iterator.hasNext()) {
            Map material;
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            int index = rowdata.getStartIndex();
            Map orgMap = (Map)data.get((Object)"org");
            if (orgMap == null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DefaultWarehouseImportOp_3", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0])).fail();
                iterator.remove();
                continue;
            }
            String orgNum = (String)orgMap.get("number");
            if (StringUtils.isBlank((CharSequence)orgNum)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DefaultWarehouseImportOp_3", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0])).fail();
                iterator.remove();
                continue;
            }
            Map<String, DynamicObject> materialCacheMap = this.materialDymOrgMap.get(orgNum);
            if (!this.orgAndBaseFilter.containsKey(orgNum)) {
                QFilter qFilter = new QFilter("number", "=", (Object)orgNum);
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])qFilter.toArray());
                if (org == null) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"DefaultWarehouseImportOp_4", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0]), orgNum)).fail();
                    iterator.remove();
                    continue;
                }
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
                HashMap<DynamicObject, QFilter> orgAndFilter = new HashMap<DynamicObject, QFilter>();
                orgAndFilter.put(org, baseDataFilter);
                this.orgAndBaseFilter.put(orgNum, orgAndFilter);
            }
            if ((material = (Map)data.get((Object)"materialnumber")) == null) {
                Map materielGrp = (Map)data.get((Object)"materialgrpnumber");
                if (null == materielGrp) continue;
                String materialGrpNum = (String)materielGrp.get("number");
                this.materielGrps.add(materialGrpNum);
                continue;
            }
            String materialNum = (String)material.get("number");
            if (materialCacheMap != null && materialCacheMap.containsKey(materialNum)) continue;
            HashSet<String> materialNums = (HashSet<String>)materialNumsMap.get(orgNum);
            if (materialNums == null) {
                materialNums = new HashSet<String>();
                materialNumsMap.put(orgNum, materialNums);
            }
            materialNums.add(materialNum);
        }
        return materialNumsMap;
    }

    private void cacheMateriel(Map<String, Set<Object>> materialNumsMap) {
        QFilter materialEnableF = new QFilter("enable", "=", (Object)true);
        materialEnableF.and("status", "=", (Object)"C");
        if (materialNumsMap.size() > 0) {
            for (Map.Entry<String, Set<Object>> next : materialNumsMap.entrySet()) {
                String orgNum = next.getKey();
                Set<Object> materialNums = next.getValue();
                Map<DynamicObject, QFilter> orgAndFilter = this.orgAndBaseFilter.get(orgNum);
                if (orgAndFilter == null) continue;
                QFilter materialqF = new QFilter("number", "in", materialNums);
                Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])materialqF.toArray());
                QFilter materialInfoF = new QFilter("masterid", "in", materials.keySet());
                QFilter baseDataFilter = orgAndFilter.values().iterator().next();
                materialInfoF = materialInfoF.and(baseDataFilter).and(materialEnableF);
                Map materialDymLoad = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])materialInfoF.toArray());
                Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(orgNum);
                if (materialDymMap == null) {
                    materialDymMap = new HashMap<String, DynamicObject>(16);
                    this.materialDymOrgMap.put(orgNum, materialDymMap);
                }
                for (DynamicObject materialDym : materialDymLoad.values()) {
                    materialDymMap.put(materialDym.getString("masterid.number"), materialDym);
                }
            }
        }
    }

    protected Map<String, Set<String>> getHasPermissionOrgs() {
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        HashMap<String, Set<String>> userToPermissOrgs = new HashMap<String, Set<String>>(16);
        List hasPermissionOrgs = NewInvOrgHelper.getPermissionOrgs((String)"im_materdefaultwh");
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            userToPermissOrgs.put(currUserId, new HashSet(16));
            return userToPermissOrgs;
        }
        for (Map orgData : hasPermissionOrgs) {
            if (!userToPermissOrgs.containsKey(currUserId)) {
                userToPermissOrgs.put(currUserId, new HashSet(16));
            }
            ((Set)userToPermissOrgs.get(currUserId)).add(orgData.get("number"));
        }
        return userToPermissOrgs;
    }
}

