/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.importop.invbiz.ininv;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.opplugin.tpl.BillTplImportOp;

public class PurInBillImportOp
extends BillTplImportOp {
    private Map<String, Object> proLinkMansMap = new HashMap<String, Object>();

    @Override
    protected void cacheBaseData(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.cacheBaseData(rowdatas, logger);
        HashSet<Object> proSupplierNums = new HashSet<Object>(16);
        HashSet<Object> bizOperatorNums = new HashSet<Object>(16);
        HashSet<Object> bizOpergrpnumbers = new HashSet<Object>(16);
        HashSet orgNumbers = new HashSet(16);
        for (ImportBillData rowdata : rowdatas) {
            Map orgMap;
            Map operatorGroup;
            Map operator;
            Map bizOpergrp;
            Map bizOperator;
            JSONObject data = rowdata.getData();
            Map supplier = (Map)data.get((Object)"supplier");
            if (supplier != null && supplier.get("number") != null) {
                proSupplierNums.add(supplier.get("number"));
            }
            if ((bizOperator = (Map)data.get((Object)"bizoperator")) != null && bizOperator.get(bizOperator.getOrDefault("importprop", "number")) != null) {
                bizOperatorNums.add(bizOperator.get(bizOperator.getOrDefault("importprop", "number")));
            }
            if ((bizOpergrp = (Map)data.get((Object)"bizoperatorgroup")) != null && bizOpergrp.get(bizOpergrp.getOrDefault("importprop", "number")) != null) {
                bizOpergrpnumbers.add(bizOpergrp.get(bizOpergrp.getOrDefault("importprop", "number")));
            }
            if ((operator = (Map)data.get((Object)"operator")) != null && operator.get(operator.getOrDefault("importprop", "number")) != null) {
                bizOperatorNums.add(operator.get(operator.getOrDefault("importprop", "number")));
            }
            if ((operatorGroup = (Map)data.get((Object)"operatorgroup")) != null && operatorGroup.get(operatorGroup.getOrDefault("importprop", "number")) != null) {
                bizOpergrpnumbers.add(operatorGroup.get(operatorGroup.getOrDefault("importprop", "number")));
            }
            if ((orgMap = (Map)data.get((Object)"org")) == null || orgMap.get(orgMap.getOrDefault("importprop", "number")) == null) continue;
            orgNumbers.add(orgMap.get(orgMap.getOrDefault("importprop", "number")));
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "in", orgNumbers).toArray());
        if (org == null) {
            return;
        }
        Long orgId = org.getLong("id");
        this.cache4Provider(proSupplierNums);
        this.cache4BizOperator(bizOperatorNums, bizOpergrpnumbers, orgId);
    }

    private void cache4Provider(Set<Object> proSupplierNums) {
        if (proSupplierNums.isEmpty()) {
            return;
        }
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", proSupplierNums)});
        HashMap<Long, String> supMap = new HashMap<Long, String>(suppliers.size());
        for (DynamicObject supplier : suppliers) {
            supMap.put(supplier.getLong("id"), supplier.getString("number"));
        }
        if (supMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection providerLinkMans = QueryServiceHelper.query((String)"bd_supplierlinkman", (String)"supplierid,id,contactperson,phone", (QFilter[])new QFilter[]{new QFilter("supplierid", "in", supMap.keySet())});
        for (DynamicObject providerLinkMan : providerLinkMans) {
            String key = (String)supMap.get(providerLinkMan.get("supplierid")) + "_" + providerLinkMan.getString("phone");
            this.proLinkMansMap.put(key, providerLinkMan.getLong("id"));
        }
    }

    @Override
    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeImportBill(rowdatas, logger);
        String purName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5458", (String)"PurInBillImportOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        String purGroupName = ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4", (String)"PurInBillImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        this.update4BizOperator(rowdatas, "bizoperator", "bizoperatorgroup", logger, purName, purGroupName);
        String manageName = ResManager.loadKDString((String)"\u5e93\u7ba1\u5458", (String)"PurInBillImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        String manageGroupName = ResManager.loadKDString((String)"\u5e93\u7ba1\u7ec4", (String)"PurInBillImportOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        this.update4BizOperator(rowdatas, "operator", "operatorgroup", logger, manageName, manageGroupName);
        for (ImportBillData rowdata : rowdatas) {
            this.importPurBindData(rowdata);
        }
    }

    private void importPurBindData(ImportBillData rowdata) {
        JSONObject data = rowdata.getData();
        List listData = (List)data.get((Object)"billentry");
        if (listData == null) {
            return;
        }
        for (Map row : listData) {
            this.update4Provider(data, row);
        }
        data.put("billentry", (Object)listData);
    }

    private void update4Provider(JSONObject data, Map<String, Object> entry) {
        Map providerlinkman = (Map)entry.get("providerlinkman");
        Map providersupplier = (Map)data.get((Object)"supplier");
        if (providerlinkman != null) {
            if (providersupplier == null) {
                entry.remove("providerlinkman");
                return;
            }
            Object prosupNum = providersupplier.get("number");
            Object prolinkmanNum = providerlinkman.get("phone");
            String key = prosupNum + "_" + prolinkmanNum;
            Object prolinkManId = this.proLinkMansMap.get(key);
            if (prolinkManId == null) {
                entry.remove("providerlinkman");
                return;
            }
            providerlinkman.put("id", prolinkManId);
        }
    }

    @Override
    protected void initBill2Qty(Map<String, Object> data, List<Map<String, Object>> listData, ImportLogger logger) {
        super.initBill2Qty(data, listData, logger);
        for (Map<String, Object> entry : listData) {
            entry.put("unverifyqty", BigDecimal.ZERO);
            entry.put("verifyqty", BigDecimal.ZERO);
            entry.put("returnqty", BigDecimal.ZERO);
            entry.put("remainreturnqty", BigDecimal.ZERO);
            entry.put("joinpriceqty", BigDecimal.ZERO);
            entry.put("remainjoinpriceqty", BigDecimal.ZERO);
            entry.put("unverifybaseqty", BigDecimal.ZERO);
            entry.put("verifybaseqty", BigDecimal.ZERO);
            entry.put("remainjoinpricebaseqty", BigDecimal.ZERO);
            entry.put("joinpricebaseqty", BigDecimal.ZERO);
            entry.put("remainreturnbaseqty", BigDecimal.ZERO);
            entry.put("returnbaseqty", BigDecimal.ZERO);
        }
    }
}

