/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.importop.locationtransfer;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.LineTypeHelper;

public class LocationTransferImportOp
extends BatchImportPlugin {
    private Map<String, Map<Object, Object>> bizOperatorMap = new HashMap<String, Map<Object, Object>>(16);
    private Map<String, DynamicObject> bizTypeMap = new HashMap<String, DynamicObject>(16);
    private Map<String, Map<String, DynamicObject>> materialDymOrgMap = new HashMap<String, Map<String, DynamicObject>>(16);
    private Map<String, Map<DynamicObject, QFilter>> orgAndBaseFilter = new HashMap<String, Map<DynamicObject, QFilter>>(16);
    private static Log log = LogFactory.getLog(LocationTransferImportOp.class);

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        try (TraceSpan span = Tracer.create((String)"LocationTransferImportOp", (String)"cacheBaseData");){
            this.cacheBaseData(rowdatas, logger);
        }
        span = Tracer.create((String)"LocationTransferImportOp", (String)"beforeImportBill");
        var4_4 = null;
        try {
            this.beforeImportBill(rowdatas, logger);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (span != null) {
                if (var4_4 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    span.close();
                }
            }
        }
        if (rowdatas == null || rowdatas.isEmpty()) {
            return null;
        }
        return super.save(rowdatas, logger);
    }

    protected void cacheBaseData(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.cacheBizOperatorData(rowdatas);
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        HashMap<String, HashSet<String>> materialNumsMap = new HashMap<String, HashSet<String>>();
        while (iterator.hasNext()) {
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            int index = rowdata.getStartIndex();
            Object bizTypeObj = data.get((Object)"biztype");
            if (bizTypeObj == null) {
                return;
            }
            Object bizTypeNumber = ((Map)bizTypeObj).get("number");
            DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_biztype", (QFilter[])new QFilter("number", "=", bizTypeNumber).toArray());
            if (bizType == null) {
                return;
            }
            this.bizTypeMap.put(bizType.getString("number"), bizType);
            Object orgObj = data.get((Object)"org");
            String billno = (String)data.get((Object)"billno");
            if (orgObj == null) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"LocationTransferImportOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), billno)).fail();
                iterator.remove();
                continue;
            }
            Map orgMap = (Map)orgObj;
            String orgNum = (String)orgMap.get("number");
            if (StringUtils.isBlank((CharSequence)orgNum)) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"LocationTransferImportOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), billno)).fail();
                iterator.remove();
                continue;
            }
            Map<String, DynamicObject> materialCacheMap = this.materialDymOrgMap.get(orgNum);
            if (!this.orgAndBaseFilter.containsKey(orgNum)) {
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNum)});
                if (org == null) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"LocationTransferImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), billno)).fail();
                    iterator.remove();
                    continue;
                }
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
                HashMap<DynamicObject, QFilter> orgAndFilter = new HashMap<DynamicObject, QFilter>();
                orgAndFilter.put(org, baseDataFilter);
                this.orgAndBaseFilter.put(orgNum, orgAndFilter);
            }
            List listData = (List)data.get((Object)"billentry");
            for (Map row : listData) {
                Map material = (Map)row.get("material");
                if (material == null) continue;
                String materialNum = (String)material.get("number");
                if (materialCacheMap != null && materialCacheMap.containsKey(materialNum)) continue;
                HashSet<String> materialNums = (HashSet<String>)materialNumsMap.get(orgNum);
                if (materialNums == null) {
                    materialNums = new HashSet<String>();
                    materialNumsMap.put(orgNum, materialNums);
                }
                if (!materialNums.add(materialNum)) continue;
            }
        }
        if (materialNumsMap.size() > 0) {
            for (Map.Entry next : materialNumsMap.entrySet()) {
                String orgNum = (String)next.getKey();
                Set materialNums = (Set)next.getValue();
                Map<DynamicObject, QFilter> orgAndFilter = this.orgAndBaseFilter.get(orgNum);
                if (orgAndFilter == null) continue;
                QFilter baseDataFilter = orgAndFilter.values().iterator().next();
                QFilter qFilter = new QFilter("masterid.number", "in", (Object)materialNums);
                qFilter.and(baseDataFilter);
                Map materialDymLoad = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])qFilter.toArray());
                for (DynamicObject materialDym : materialDymLoad.values()) {
                    Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(orgNum);
                    if (materialDymMap == null) {
                        materialDymMap = new HashMap<String, DynamicObject>();
                        this.materialDymOrgMap.put(orgNum, materialDymMap);
                    }
                    materialDymMap.put(materialDym.getString("masterid.number"), materialDym);
                }
            }
        }
    }

    protected void cacheBizOperatorData(List<ImportBillData> rowdatas) {
        HashSet<Object> bizOperatorNums = new HashSet<Object>(16);
        HashSet<Object> bizOperaGrpNumbers = new HashSet<Object>(16);
        HashSet orgNumbers = new HashSet(16);
        for (ImportBillData rowdata : rowdatas) {
            Map orgMap;
            Map operatorGroup;
            JSONObject data = rowdata.getData();
            Map operator = (Map)data.get((Object)"operator");
            if (operator != null && operator.get(operator.getOrDefault("importprop", "number")) != null) {
                bizOperatorNums.add(operator.get(operator.getOrDefault("importprop", "number")));
            }
            if ((operatorGroup = (Map)data.get((Object)"operatorgroup")) != null && operatorGroup.get(operatorGroup.getOrDefault("importprop", "number")) != null) {
                bizOperaGrpNumbers.add(operatorGroup.get(operatorGroup.getOrDefault("importprop", "number")));
            }
            if ((orgMap = (Map)data.get((Object)"org")) == null || orgMap.get(orgMap.getOrDefault("importprop", "number")) == null) continue;
            orgNumbers.add(orgMap.get(orgMap.getOrDefault("importprop", "number")));
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "in", orgNumbers).toArray());
        if (org == null) {
            return;
        }
        Long orgId = org.getLong("id");
        this.cache4BizOperator(bizOperatorNums, bizOperaGrpNumbers, orgId);
    }

    private void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            this.handleRowData(logger, iterator);
        }
        String manageName = ResManager.loadKDString((String)"\u5e93\u7ba1\u5458", (String)"LocationTransferImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        String manageGroupName = ResManager.loadKDString((String)"\u5e93\u7ba1\u7ec4", (String)"LocationTransferImportOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        this.update4BizOperator(rowdatas, "operator", "operatorgroup", logger, manageName, manageGroupName);
    }

    private void handleRowData(ImportLogger logger, Iterator<ImportBillData> iterator) {
        ImportBillData rowdata = iterator.next();
        JSONObject data = rowdata.getData();
        this.initHeadData(data);
        Map orgMap = (Map)data.get((Object)"org");
        if (orgMap == null) {
            return;
        }
        String orgNum = (String)orgMap.get("number");
        if (StringUtils.isBlank((CharSequence)orgNum)) {
            return;
        }
        Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(orgNum);
        if (materialDymMap == null) {
            return;
        }
        List listData = (List)data.get((Object)"billentry");
        for (Map row : listData) {
            this.initEntryData(data, row);
            Map material = (Map)row.get("material");
            String materialNum = (String)material.get("number");
            DynamicObject materialDym = materialDymMap.get(materialNum);
            boolean isdisposable = materialDym.getBoolean("masterid.isdisposable");
            if (isdisposable) continue;
            row.put("materialname", materialDym.getString("masterid.name"));
        }
        data.put("billentry", (Object)listData);
    }

    protected void initHeadData(JSONObject data) {
        data.put("billstatus", (Object)"A");
        data.put("billcretype", (Object)"1");
    }

    protected void initEntryData(JSONObject data, Map<String, Object> row) {
        Map importLineTypeMap = (Map)row.get("linetype");
        if (importLineTypeMap != null) {
            return;
        }
        Map importBizTypeMap = (Map)data.get((Object)"biztype");
        DynamicObject bizType = this.bizTypeMap.get(importBizTypeMap.get("number"));
        if (bizType != null) {
            DynamicObject lineType = LineTypeHelper.getLineTypeByBizType((DynamicObject)bizType);
            if (lineType == null) {
                return;
            }
            HashMap<String, String> lineTypeMap = new HashMap<String, String>(4);
            lineTypeMap.put("importprop", "number");
            lineTypeMap.put("number", lineType.getString("number"));
            lineTypeMap.put("name", lineType.getString("name"));
            row.put("linetype", JSONObject.toJSON(lineTypeMap));
        }
    }

    protected void cache4BizOperator(Set<Object> bizOperatorNums, Set<Object> bizOpergrpnumbers, Long orgId) {
        if (bizOperatorNums.isEmpty()) {
            return;
        }
        QFilter operFilter = new QFilter("entryentity.operatornumber", "in", bizOperatorNums);
        if (!bizOpergrpnumbers.isEmpty()) {
            operFilter.and("number", "in", bizOpergrpnumbers);
        }
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map bizOperatorGrps = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,number,createorg,entryentity.id,entryentity.operatornumber", (QFilter[])new QFilter[]{operFilter, qFilter});
        for (DynamicObject bizOperatorGrp : bizOperatorGrps.values()) {
            String grpNum = bizOperatorGrp.getString("number");
            DynamicObjectCollection entryentity = bizOperatorGrp.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                String operatorNum = entry.getString("operatornumber");
                String key = operatorNum + "_" + grpNum;
                HashMap<Object, Object> pkValueMap = new HashMap<Object, Object>(1);
                pkValueMap.put(entry.getPkValue(), bizOperatorGrp.getPkValue());
                this.bizOperatorMap.put(key, pkValueMap);
                this.bizOperatorMap.put(operatorNum, pkValueMap);
            }
        }
    }

    protected void update4BizOperator(List<ImportBillData> rowdatas, String bizoperator, String bizoperatorgroup, ImportLogger logger, String operatorName, String operatorGroupName) {
        Iterator<ImportBillData> rowIterator = rowdatas.iterator();
        while (rowIterator.hasNext()) {
            String key;
            Map<Object, Object> pkValueMap;
            ImportBillData rowdata = rowIterator.next();
            JSONObject data = rowdata.getData();
            int startIndex = rowdata.getStartIndex();
            String billNo = (String)data.get((Object)"billno");
            Map bizOperator = (Map)data.get((Object)bizoperator);
            Map bizOperatorgroup = (Map)data.get((Object)bizoperatorgroup);
            if (bizOperator == null || bizOperator.get(bizOperator.getOrDefault("importprop", "number")) == null) {
                if (bizOperatorgroup == null) continue;
                data.remove((Object)bizoperatorgroup);
                continue;
            }
            String operatorNum = (String)bizOperator.get(bizOperator.getOrDefault("importprop", "number"));
            StringBuilder sb = new StringBuilder();
            sb.append(operatorNum);
            Map bizOpergrp = (Map)data.get((Object)bizoperatorgroup);
            bizOpergrp = bizOpergrp == null ? new HashMap(1) : bizOpergrp;
            String bizOperGrpNum = (String)bizOpergrp.get(bizOpergrp.getOrDefault("importprop", "number"));
            if (bizOperGrpNum != null) {
                sb.append("_").append(bizOperGrpNum);
            }
            if ((pkValueMap = this.bizOperatorMap.get(key = sb.toString())) != null) {
                Iterator<Map.Entry<Object, Object>> iterator = pkValueMap.entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry<Object, Object> next = iterator.next();
                bizOperator.put("id", next.getKey());
                if (!bizOpergrp.isEmpty()) continue;
                bizOpergrp.put("id", next.getValue());
                data.put(bizoperatorgroup, (Object)bizOpergrp);
                continue;
            }
            logger.log(Integer.valueOf(startIndex), String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1s\u201d\u3001\u201c%2s\u201d\u548c\u201c%3s\u201d\u4e0d\u5339\u914d\u3002", (String)"LocationTransferImportOp_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), billNo, operatorName, operatorGroupName)).fail();
            rowIterator.remove();
        }
    }
}

