/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.inbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class OsPurInBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("osunverifyqty");
        e.getFieldKeys().add("osunverifybaseqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"PurInBillSubmitOp", (String)"beginOperationTransaction");){
            DynamicObject[] bills;
            super.beginOperationTransaction(e);
            for (DynamicObject bill : bills = e.getDataEntities()) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    BigDecimal baseQty = entry.getBigDecimal("baseqty");
                    BigDecimal qty = entry.getBigDecimal("qty");
                    BigDecimal returnQty = entry.getBigDecimal("returnqty");
                    entry.set("osunverifyqty", (Object)qty.subtract(returnQty));
                    BigDecimal returnBaseQty = entry.getBigDecimal("returnbaseqty");
                    entry.set("osunverifybaseqty", (Object)baseQty.subtract(returnBaseQty));
                    entry.set("osverifybaseqty", (Object)BigDecimal.ZERO);
                    entry.set("osverifyqty", (Object)BigDecimal.ZERO);
                }
            }
        }
    }
}

