/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.inbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bd.sbd.consts.BizTypeConsts;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.InvCheckRecInBillMatBaseQtyHelper;

public class PurInBillAuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(PurInBillAuditOp.class);
    private static List<String> verifyFields = new ArrayList<String>(32);
    private static List<String> allVerifyFields;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(allVerifyFields);
        e.getFieldKeys().add("isinitbill");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"PurInBillAuditOp", (String)"beginOperationTransaction");){
            super.beginOperationTransaction(e);
            DynamicObject[] bills = e.getDataEntities();
            this.setRwFields(bills);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"PurInBillAuditOp", (String)"endOperationTransaction");){
            super.endOperationTransaction(e);
            DynamicObject[] bills = e.getDataEntities();
            InvCheckRecInBillMatBaseQtyHelper.checkBaseQtyList((DynamicObject[])bills, (String)e.getOperationKey());
        }
    }

    private void setRwFields(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            boolean isUpdate = this.isUpdateWarehouse(bill);
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entryList) {
                if (isUpdate) {
                    this.updateWarehouse(entry);
                }
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                BigDecimal qty = entry.getBigDecimal("qty");
                entry.set("returnbaseqty", (Object)BigDecimal.ZERO);
                entry.set("returnqty", (Object)BigDecimal.ZERO);
                BigDecimal returnQty = entry.getBigDecimal("returnqty");
                entry.set("remainreturnqty", (Object)qty.subtract(returnQty));
                BigDecimal returnBaseQty = entry.getBigDecimal("returnbaseqty");
                entry.set("remainreturnbaseqty", (Object)baseQty.subtract(returnBaseQty));
                entry.set("joinpriceqty", (Object)BigDecimal.ZERO);
                BigDecimal joinPriceQty = entry.getBigDecimal("joinpriceqty");
                entry.set("remainjoinpriceqty", (Object)qty.subtract(joinPriceQty));
                entry.set("joinpricebaseqty", (Object)BigDecimal.ZERO);
                BigDecimal joinPriceBaseQty = entry.getBigDecimal("joinpricebaseqty");
                entry.set("remainjoinpricebaseqty", (Object)baseQty.subtract(joinPriceBaseQty));
                entry.set("verifyqty", (Object)BigDecimal.ZERO);
                BigDecimal verifyQty = entry.getBigDecimal("verifyqty");
                entry.set("unverifyqty", (Object)qty.subtract(verifyQty));
                entry.set("verifybaseqty", (Object)BigDecimal.ZERO);
                BigDecimal verifyBaseQty = entry.getBigDecimal("verifybaseqty");
                entry.set("unverifybaseqty", (Object)baseQty.subtract(verifyBaseQty));
                DynamicObject bizType = bill.getDynamicObject("biztype");
                if (!BizTypeConsts.BIZTYPE_PURINRETURN_VMI.equals(bizType.getPkValue()) && !BizTypeConsts.BIZTYPE_PURIN_VMI.equals(bizType.getPkValue())) continue;
                entry.set("vmisettleqty", (Object)BigDecimal.ZERO);
                BigDecimal vmiSettleQty = entry.getBigDecimal("vmisettleqty");
                entry.set("vmiremainsettleqty", (Object)qty.subtract(vmiSettleQty));
                entry.set("vmisettleqty", (Object)BigDecimal.ZERO);
                BigDecimal vmiSettleBaseQty = entry.getBigDecimal("vmisettleqty");
                entry.set("vmiremainsettlebaseqty", (Object)baseQty.subtract(vmiSettleBaseQty));
            }
        }
    }

    private void updateWarehouse(DynamicObject entry) {
        DynamicObject wareHouse = entry.getDynamicObject("warehouse");
        if (wareHouse == null) {
            return;
        }
        DynamicObject location = entry.getDynamicObject("location");
        DynamicObject outWareHouse = entry.getDynamicObject("outwarehouse");
        if (outWareHouse == null) {
            entry.set("outwarehouse", (Object)wareHouse);
            entry.set("outlocation", (Object)location);
        }
    }

    private boolean isUpdateWarehouse(DynamicObject bill) {
        DynamicObject invScheme = bill.getDynamicObject("invscheme");
        if (invScheme == null) {
            return false;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        return isInUpdate && isOutUpdate;
    }

    static {
        verifyFields.add("id");
        verifyFields.add("billno");
        verifyFields.add("biztime");
        verifyFields.add("supplier");
        verifyFields.add("settlecurrency");
        verifyFields.add("currency");
        verifyFields.add("exchangerate");
        verifyFields.add("billentry.id");
        verifyFields.add("billentry.material");
        verifyFields.add("billentry.unit");
        verifyFields.add("billentry.baseunit");
        verifyFields.add("billentry.qty");
        verifyFields.add("billentry.actualprice");
        verifyFields.add("billentry.actualtaxprice");
        verifyFields.add("billentry.amount");
        verifyFields.add("billentry.ispresent");
        verifyFields.add("billentry.mainbillnumber");
        verifyFields.add("billentry.mainbillentryseq");
        verifyFields.add("billentry.entrysettleorg");
        verifyFields.add("billentry.unverifyqty");
        verifyFields.add("billentry.srcbillentryid");
        allVerifyFields = new ArrayList<String>(64);
        allVerifyFields.add("remainreturnqty");
        allVerifyFields.add("remainreturnbaseqty");
        allVerifyFields.add("remainjoinpriceqty");
        allVerifyFields.add("remainjoinpricebaseqty");
        allVerifyFields.add("returnqty");
        allVerifyFields.add("returnbaseqty");
        allVerifyFields.add("joinpriceqty");
        allVerifyFields.add("joinpricebaseqty");
        allVerifyFields.add("verifyqty");
        allVerifyFields.add("verifybaseqty");
        allVerifyFields.add("unverifyqty");
        allVerifyFields.add("unverifybaseqty");
        allVerifyFields.add("vmisettleqty");
        allVerifyFields.add("vmisettlebaseqty");
        allVerifyFields.add("vmiremainsettleqty");
        allVerifyFields.add("vmiremainsettlebaseqty");
        allVerifyFields.add("biztype");
        allVerifyFields.add("invscheme");
        allVerifyFields.add("ischargeoff");
        allVerifyFields.addAll(verifyFields);
    }
}

