/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.inbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.enums.DiscountTypeEnum;

public class PurInBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bizorg");
        e.getFieldKeys().add("entryreqorg");
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("deductiblerate");
        e.getFieldKeys().add("curdeductibleamt");
        e.getFieldKeys().add("intercostamt");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("outwarehouse");
        e.getFieldKeys().add("outlocation");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("ispresent");
        e.getFieldKeys().add("discounttype");
        e.getFieldKeys().add("discountrate");
        e.getFieldKeys().add("discountamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject order : datas = e.getDataEntities()) {
            DynamicObject invScheme = order.getDynamicObject("invscheme");
            if (invScheme == null) {
                return;
            }
            boolean isInUpdate = invScheme.getBoolean("isinupdate");
            boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
            DynamicObjectCollection entryRow = order.getDynamicObjectCollection("billentry");
            for (DynamicObject row : entryRow) {
                BigDecimal discountRate;
                if (isInUpdate && isOutUpdate) {
                    DynamicObject wareHouse = row.getDynamicObject("warehouse");
                    if (wareHouse == null) continue;
                    DynamicObject location = row.getDynamicObject("location");
                    DynamicObject outWareHouse = row.getDynamicObject("outwarehouse");
                    if (outWareHouse == null) {
                        row.set("outwarehouse", (Object)wareHouse);
                        row.set("outlocation", (Object)location);
                    }
                }
                String discountType = row.getString("discounttype");
                if (!DiscountTypeEnum.DISRATE.getValue().equals(discountType) || (discountRate = row.getBigDecimal("discountrate")).compareTo(BigDecimalConstants.ONEHUNDRED) != 0) continue;
                row.set("ispresent", (Object)true);
                BigDecimal price = row.getBigDecimal("price");
                if (BigDecimal.ZERO.compareTo(price) != 0) continue;
                row.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                row.set("discountrate", (Object)Constants.ZERO);
                row.set("discountamount", (Object)Constants.ZERO);
            }
        }
    }
}

