/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.inbill;

import java.math.BigDecimal;
import kd.bd.sbd.consts.BizTypeConsts;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.InvCheckRecInBillMatBaseQtyHelper;
import kd.scmc.im.business.helper.InvoiceBizHelper;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.validator.general.TransitLocationMustInputValidator;

public class PurInBillSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String[] SUPPLIERKEYS = new String[]{"invoicesupplier", "receivesupplier", "providersupplier"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("ispresent");
        e.getFieldKeys().add("price");
        e.getFieldKeys().add("remainreturnqty");
        e.getFieldKeys().add("remainreturnbaseqty");
        e.getFieldKeys().add("remainjoinpriceqty");
        e.getFieldKeys().add("remainjoinpricebaseqty");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("joinpriceqty");
        e.getFieldKeys().add("joinpricebaseqty");
        e.getFieldKeys().add("verifyqty");
        e.getFieldKeys().add("verifybaseqty");
        e.getFieldKeys().add("unverifyqty");
        e.getFieldKeys().add("unverifybaseqty");
        e.getFieldKeys().add("vmisettleqty");
        e.getFieldKeys().add("vmisettlebaseqty");
        e.getFieldKeys().add("vmiremainsettleqty");
        e.getFieldKeys().add("vmiremainsettlebaseqty");
        e.getFieldKeys().add("deductiblerate");
        e.getFieldKeys().add("curdeductibleamt");
        e.getFieldKeys().add("intercostamt");
        e.getFieldKeys().add("taxpayertype");
        e.getFieldKeys().add("invoicesupplier");
        e.getFieldKeys().add("receivesupplier");
        e.getFieldKeys().add("providersupplier");
        e.getFieldKeys().add("settlecurrency");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("quotation");
        e.getFieldKeys().add("taxrate");
        e.getFieldKeys().add("curamount");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("curamountandtax");
        e.getFieldKeys().add("amountandtax");
        e.getFieldKeys().add("istax");
        e.getFieldKeys().add("invoicebiztype");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("outwarehouse");
        e.getFieldKeys().add("outlocation");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("discounttype");
        e.getFieldKeys().add("discountrate");
        e.getFieldKeys().add("discountamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new TransitLocationMustInputValidator("outwarehouse", "outlocation"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"PurInBillSubmitOp", (String)"beginOperationTransaction");){
            DynamicObject[] bills;
            super.beginOperationTransaction(e);
            for (DynamicObject bill : bills = e.getDataEntities()) {
                boolean isUpdate = this.isUpdateWarehouse(bill);
                Object supplier = bill.get("supplier");
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    BigDecimal discountRate;
                    if (isUpdate) {
                        this.updateWarehouse(entry);
                    }
                    this.setEntrySupplier(entry, supplier == null ? null : (DynamicObject)supplier, SUPPLIERKEYS);
                    BigDecimal baseQty = entry.getBigDecimal("baseqty");
                    BigDecimal qty = entry.getBigDecimal("qty");
                    entry.set("returnbaseqty", (Object)BigDecimal.ZERO);
                    entry.set("returnqty", (Object)BigDecimal.ZERO);
                    BigDecimal returnQty = entry.getBigDecimal("returnqty");
                    entry.set("remainreturnqty", (Object)qty.subtract(returnQty));
                    BigDecimal returnBaseQty = entry.getBigDecimal("returnbaseqty");
                    entry.set("remainreturnbaseqty", (Object)baseQty.subtract(returnBaseQty));
                    entry.set("joinpriceqty", (Object)BigDecimal.ZERO);
                    BigDecimal joinPriceQty = entry.getBigDecimal("joinpriceqty");
                    entry.set("remainjoinpriceqty", (Object)qty.subtract(joinPriceQty));
                    entry.set("joinpricebaseqty", (Object)BigDecimal.ZERO);
                    BigDecimal joinPriceBaseQty = entry.getBigDecimal("joinpricebaseqty");
                    entry.set("remainjoinpricebaseqty", (Object)baseQty.subtract(joinPriceBaseQty));
                    entry.set("verifyqty", (Object)BigDecimal.ZERO);
                    BigDecimal verifyQty = entry.getBigDecimal("verifyqty");
                    entry.set("unverifyqty", (Object)qty.subtract(verifyQty));
                    entry.set("verifybaseqty", (Object)BigDecimal.ZERO);
                    BigDecimal verifyBaseQty = entry.getBigDecimal("verifybaseqty");
                    entry.set("unverifybaseqty", (Object)baseQty.subtract(verifyBaseQty));
                    DynamicObject bizType = bill.getDynamicObject("biztype");
                    if (BizTypeConsts.BIZTYPE_PURINRETURN_VMI.equals(bizType.getPkValue()) || BizTypeConsts.BIZTYPE_PURIN_VMI.equals(bizType.getPkValue())) {
                        entry.set("vmisettleqty", (Object)BigDecimal.ZERO);
                        BigDecimal vmiSettleQty = entry.getBigDecimal("vmisettleqty");
                        entry.set("vmiremainsettleqty", (Object)qty.subtract(vmiSettleQty));
                        entry.set("vmisettleqty", (Object)BigDecimal.ZERO);
                        BigDecimal vmiSettleBaseQty = entry.getBigDecimal("vmisettleqty");
                        entry.set("vmiremainsettlebaseqty", (Object)baseQty.subtract(vmiSettleBaseQty));
                    }
                    String discountType = entry.getString("discounttype");
                    if (!DiscountTypeEnum.DISRATE.getValue().equals(discountType) || (discountRate = entry.getBigDecimal("discountrate")).compareTo(BigDecimalConstants.ONEHUNDRED) != 0) continue;
                    entry.set("ispresent", (Object)true);
                    BigDecimal price = entry.getBigDecimal("price");
                    if (BigDecimal.ZERO.compareTo(price) != 0) continue;
                    entry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                    entry.set("discountrate", (Object)Constants.ZERO);
                    entry.set("discountamount", (Object)Constants.ZERO);
                }
                DynamicObject originInvoiceBiz = bill.getDynamicObject("invoicebiztype");
                String appId = this.billEntityType.getAppId();
                InvoiceBizHelper.handleInvoiceBizNull((DynamicObject)bill, (String)appId);
                DynamicObject newInvoiceBiz = bill.getDynamicObject("invoicebiztype");
                if (originInvoiceBiz != null || newInvoiceBiz == null) continue;
                InvoiceBizHelper.handleAlgorithmSubmit((DynamicObject)bill);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"PurInBillSubmitOp", (String)"endOperationTransaction");){
            super.endOperationTransaction(e);
            DynamicObject[] bills = e.getDataEntities();
            InvCheckRecInBillMatBaseQtyHelper.checkBaseQtyList((DynamicObject[])bills, (String)e.getOperationKey());
        }
    }

    private void updateWarehouse(DynamicObject entry) {
        DynamicObject wareHouse = entry.getDynamicObject("warehouse");
        if (wareHouse == null) {
            return;
        }
        DynamicObject location = entry.getDynamicObject("location");
        DynamicObject outWareHouse = entry.getDynamicObject("outwarehouse");
        if (outWareHouse == null) {
            entry.set("outwarehouse", (Object)wareHouse);
            entry.set("outlocation", (Object)location);
        }
    }

    private boolean isUpdateWarehouse(DynamicObject bill) {
        DynamicObject invScheme = bill.getDynamicObject("invscheme");
        if (invScheme == null) {
            return false;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        return isInUpdate && isOutUpdate;
    }

    private void setEntrySupplier(DynamicObject entry, DynamicObject supplier, String[] fieldKeys) {
        if (supplier == null) {
            return;
        }
        for (String fieldKey : fieldKeys) {
            Object value = entry.get(fieldKey);
            if (value != null) continue;
            entry.set(fieldKey, (Object)supplier);
        }
    }
}

