/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.inbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class PurInbillUnAuditToPurInstockOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PurInbillUnAuditToPurInstockOp.class);
    private static final String PUR_PURINSOTCK = "pur_instock";
    private static final String PUR_RETURN = "pur_return";
    private static final String REVERSE = "1";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("supplier");
        keys.add("invscheme");
        keys.add("biztype");
        keys.add("billentry");
        keys.add("isinitbill");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        boolean isCQConfig;
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0004")) {
            return;
        }
        int length = dataEntities.length;
        ArrayList<Long> blueIds = new ArrayList<Long>(16);
        ArrayList<Long> redIds = new ArrayList<Long>(16);
        try {
            isCQConfig = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u67e5\u770b\u662f\u5426\u6765\u6e90\u82cd\u7a79\u63a5\u53e3\u5f02\u5e38", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u67e5\u770b\u662f\u5426\u6765\u6e90\u82cd\u7a79\u63a5\u53e3\u5f02\u5e38, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"PurInbillUnAuditToPurInstockOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < length; ++i) {
            DynamicObject dyn = dataEntities[i];
            DynamicObject supplier = dyn.getDynamicObject("supplier");
            if (supplier == null) continue;
            DynamicObject invScheme = dyn.getDynamicObject("invscheme");
            String bizDirection = invScheme.getString("bizdirection");
            boolean isRedBill = REVERSE.equals(bizDirection);
            boolean isSuppColla = supplier.getBoolean("issuppcolla");
            if (!isSuppColla || !isCQConfig) continue;
            if (isRedBill) {
                redIds.add((Long)dyn.getPkValue());
                continue;
            }
            blueIds.add((Long)dyn.getPkValue());
        }
        if (!blueIds.isEmpty()) {
            List loadLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)"im_purinbill", (Long[])blueIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            Set<Object> findTargetBillIds = this.getTargetBillIds(loadLinkDownNodes);
            this.deleteTargetBill(findTargetBillIds, PUR_PURINSOTCK);
        }
        if (!redIds.isEmpty()) {
            List loadReturnLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)"im_purinbill", (Long[])redIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            Set<Object> findReturnTargetBills = this.getTargetBillIds(loadReturnLinkDownNodes);
            this.deleteTargetBill(findReturnTargetBills, PUR_RETURN);
        }
    }

    private Set<Object> getTargetBillIds(List<BFRowLinkDownNode> loadLinkDownNodes) {
        HashSet<Object> findTargetBillIds = new HashSet<Object>();
        for (BFRowLinkDownNode node : loadLinkDownNodes) {
            Map srowIdMap = node.getTNodes();
            for (BFRowLinkDownNode sNode : srowIdMap.values()) {
                Long targetBillId = sNode.getRowId().getBillId();
                findTargetBillIds.add(targetBillId);
            }
        }
        return findTargetBillIds;
    }

    private void deleteTargetBill(Set<Object> findTargetBillIds, String entityName) {
        if (findTargetBillIds == null || findTargetBillIds.isEmpty()) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>(findTargetBillIds);
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("ids", list);
        param.put("entityName", entityName);
        try {
            log.info("\u5f00\u59cb\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u63a5\u53e3");
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"unAuditAndDeleteBill", (Object[])new Object[]{param});
            log.info("\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u63a5\u53e3\u7ed3\u679c --> " + result);
            boolean success = (Boolean)result.get("success");
            if (!success) {
                String msg = (String)result.get("message");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u63a5\u53e3\u5931\u8d25\uff1a", (String)"PurInbillUnAuditToPurInstockOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), msg));
            }
        }
        catch (Exception e2) {
            log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e2);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u63a5\u53e3\u5931\u8d25, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"PurInbillUnAuditToPurInstockOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }
}

