/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.init;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;

public class InitBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("inputamount");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("org");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        this.buildCurrency(e.getDataEntities());
    }

    private void buildCurrency(DynamicObject[] bills) {
        HashSet<Long> orgIds = new HashSet<Long>(bills.length);
        for (DynamicObject bill : bills) {
            if (bill.getDynamicObject("currency") != null) continue;
            orgIds.add(bill.getLong("org_id"));
        }
        if (orgIds.isEmpty()) {
            return;
        }
        HashMap<Long, Long> orgAndCurrencyMap = new HashMap<Long, Long>(orgIds.size());
        for (Long orgId : orgIds) {
            Map currencyAndExRateTableCache = CurrencyHelper.getCurrencyAndExRateTableCache((Long)orgId);
            if (currencyAndExRateTableCache == null) continue;
            orgAndCurrencyMap.put(orgId, currencyAndExRateTableCache.getOrDefault("baseCurrencyID", 0L));
        }
        if (orgAndCurrencyMap.isEmpty()) {
            return;
        }
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((Object[])orgAndCurrencyMap.values().toArray(), (String)"bd_currency");
        for (DynamicObject bill : bills) {
            if (bill.getDynamicObject("currency") != null) continue;
            long orgId = bill.getLong("org_id");
            Long currencyId = (Long)orgAndCurrencyMap.get(orgId);
            bill.set("currency", currencyMap.get(currencyId));
        }
    }
}

