/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.location;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.validator.improt.BillTplImprotValidator;
import kd.scmc.im.validator.plugin.TransFormBillValidatorPlugin;

public class LocationTransferSaveOP
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new BillTplImprotValidator());
        TransFormBillValidatorPlugin tplValidator = new TransFormBillValidatorPlugin(e, "save", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("materialmasterid");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("settlescurrency");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"LocationTransferSaveOP", (String)"beginOperationTransaction");){
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities.length == 0) {
                return;
            }
            MainEntityType dataEntityType = (MainEntityType)dataEntities[0].getDataEntityType();
            IDataEntityProperty bookDateProp = dataEntityType.findProperty("bookdate");
            for (DynamicObject dataEntity : dataEntities) {
                String billCreType = dataEntity.getString("billcretype");
                if (bookDateProp != null) {
                    this.updateBookDate(dataEntity, bookDateProp);
                }
                if (!"1".equals(billCreType) && !"3".equals(billCreType)) continue;
                DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    DynamicObject material = entry.getDynamicObject("material");
                    if (material == null) continue;
                    entry.set("materialmasterid", (Object)material.getDynamicObject("masterid"));
                }
                DynamicObject settleCurreny = dataEntity.getDynamicObject("settlescurrency");
                if (settleCurreny != null) continue;
                Long orgId = (Long)dataEntity.getDynamicObject("org").getPkValue();
                dataEntity.set("settlescurrency", (Object)CurrencyHelper.getCurrency((Long)orgId));
            }
        }
    }

    private void updateBookDate(DynamicObject data, IDataEntityProperty bookDateProp) {
        Date bookDate = data.getDate(bookDateProp);
        if (bookDate == null) {
            data.set("bookdate", (Object)data.getDate("biztime"));
        }
    }
}

