/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.outbill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.LineTypeHelper;
import kd.scmc.im.validator.improt.BillTplImportHandle;
import kd.scmc.im.validator.improt.ImportHandleUnit;
import kd.scmc.im.validator.plugin.ApplyBillValidatorPlugin;

public class MaterialReqBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("bizorg");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("materialmasterid");
        e.getFieldKeys().add("biztype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        BillTplImportHandle improtHandle;
        List<String> errorMsg;
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> importData = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> integrationData = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : dataEntities) {
            String srcsystem;
            DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
            dataEntity.set("lastupdateuser", (Object)UserServiceHelper.getCurrentUser((String)"id"));
            dataEntity.set("lastupdatetime", (Object)new Date());
            String billCreType = dataEntity.getString("billcretype");
            if ("1".equals(billCreType) || "3".equals(billCreType)) {
                importData.add(dataEntity);
            }
            if (billEntry == null || billEntry.size() == 0 || !"EAS".equals(srcsystem = ((DynamicObject)billEntry.get(0)).getString("srcsystem"))) continue;
            integrationData.add(dataEntity);
        }
        if (importData.isEmpty()) {
            return;
        }
        if (!integrationData.isEmpty()) {
            for (DynamicObject item : integrationData) {
                String formId = item.getDataEntityType().getName();
                if ("im_materialreqbill".equals(formId)) {
                    this.settleCurrencyHandle(item);
                    this.setLineType(item);
                }
                if (!"im_transapply".equals(formId)) continue;
                this.setLineType(item);
            }
        }
        if (!(errorMsg = (improtHandle = ImportHandleUnit.getImportHandle(importData)).getErrorMsg()).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String err : errorMsg) {
                sb.append(err).append("\r\n");
            }
            throw new KDBizException(sb.toString());
        }
    }

    private void settleCurrencyHandle(DynamicObject data) {
        Long orgId;
        Map map;
        DynamicObject org = data.getDynamicObject("org");
        if (org != null && (map = CurrencyHelper.getCurrencyAndExRateTable((Long)(orgId = (Long)org.getPkValue()))) != null && map.size() != 0) {
            data.set("settlecurrency_id", map.get("baseCurrencyID"));
        }
    }

    private void setLineType(DynamicObject data) {
        DynamicObject bizType = data.getDynamicObject("biztype");
        if (bizType != null) {
            Long bizTypeId = (Long)bizType.getPkValue();
            Long lineTypeId = LineTypeHelper.getDefaultLineType((Long)bizTypeId);
            DynamicObjectCollection billentry = data.getDynamicObjectCollection("billentry");
            for (DynamicObject dynamicObject : billentry) {
                dynamicObject.set("linetype", (Object)lineTypeId);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        ApplyBillValidatorPlugin tplValidator = new ApplyBillValidatorPlugin(e, "save", this.billEntityType.getName());
        tplValidator.validate();
    }
}

