/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.outbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.scmc.im.business.helper.BillQtyAndUnitHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.ExRateCacheHelper;
import kd.scmc.im.validator.outbill.MaterialReqOutQueryPriceValidator;

public class MaterialReqOutQueryPriceOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MaterialReqOutQueryPriceOp.class);
    private static final String PRICEKEY = "price";
    private static final String CURRENCYKEY = "currency";
    private Map<Long, Map<String, Object>> cacheMap;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("biztime");
        fieldKeys.add("bookdate");
        fieldKeys.add("settlecurrency");
        fieldKeys.add("billentry");
        fieldKeys.add("material");
        fieldKeys.add("auxpty");
        fieldKeys.add("warehouse");
        fieldKeys.add("location");
        fieldKeys.add("lotnumber");
        fieldKeys.add("outownertype");
        fieldKeys.add("outowner");
        fieldKeys.add("ownertype");
        fieldKeys.add("owner");
        fieldKeys.add("qty");
        fieldKeys.add(PRICEKEY);
        fieldKeys.add("amount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MaterialReqOutQueryPriceValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        logger.info("MaterialReqOutQueryPriceOp=====\u5f00\u59cb\u5916\u90e8\u5355\u636e\u53d6\u6210\u672c\u4ef7, \u5355\u636e\u6570\u91cf:" + bills.length);
        if (bills.length == 0) {
            return;
        }
        this.cachePricingInfo(bills);
        Map<Object, Map<String, Object>> costPriceResult = this.queryPrice(bills);
        logger.info("MaterialReqOutQueryPriceOp=====\u5916\u90e8\u5355\u636e\u53d6\u6210\u672c\u4ef7\u7ed3\u679c:" + costPriceResult);
        this.fillToBill(bills, costPriceResult);
        SaveServiceHelper.save((DynamicObject[])bills);
        logger.info("MaterialReqOutQueryPriceOp=====\u5916\u90e8\u5355\u636e\u53d6\u6210\u672c\u4ef7\u6210\u529f");
    }

    private void fillToBill(DynamicObject[] bills, Map<Object, Map<String, Object>> result) {
        for (DynamicObject bill : bills) {
            String billNo = bill.getString("billno");
            Long billId = bill.getLong("id");
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            this.fillToBillEntry(billId, billNo, billEntry, result);
        }
    }

    private void fillToBillEntry(Long billId, String billNo, DynamicObjectCollection billEntry, Map<Object, Map<String, Object>> result) {
        boolean rowIndex = false;
        HashMap<Long, BigDecimal> currencyExrate = new HashMap<Long, BigDecimal>(result.size());
        Map<String, Object> billExRateMap = this.cacheMap.get(billId);
        for (DynamicObject entry : billEntry) {
            Long entryId = entry.getLong("id");
            Map<String, Object> priceResult = result.get(entryId);
            if (priceResult == null || priceResult.size() == 0) continue;
            BigDecimal price = (BigDecimal)priceResult.get(PRICEKEY);
            Long currencyId = (Long)priceResult.get(CURRENCYKEY);
            Long targetCurrency = (Long)billExRateMap.get("targetCurrency");
            if (!targetCurrency.equals(currencyId)) {
                BigDecimal exRate = (BigDecimal)currencyExrate.get(currencyId);
                Long exRateTableId = (Long)billExRateMap.get("exchangeRateTableID");
                Date exRateDate = (Date)billExRateMap.get("exRateDate");
                if (exRate == null) {
                    exRate = ExRateCacheHelper.getExRate((Long)exRateTableId, (Long)currencyId, (Long)targetCurrency, (Date)exRateDate);
                    currencyExrate.put(currencyId, exRate);
                }
                if (exRate != null) {
                    price = price.multiply(exRate);
                }
            }
            entry.set(PRICEKEY, (Object)price);
            BigDecimal qty = entry.getBigDecimal("qty");
            if (qty == null || price == null || price.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0) continue;
            int precision = (Integer)billExRateMap.get("precision");
            BigDecimal amount_all = qty.multiply(price);
            BillQtyAndUnitHelper.showAmountErrorTip((BigDecimal)amount_all);
            entry.set("amount", (Object)amount_all.setScale(precision, 4));
        }
    }

    private Map<Object, Map<String, Object>> queryPrice(DynamicObject[] bills) {
        Map<Long, Map<String, Object>> allParams = this.buildPriceParam(bills);
        HashMap<Object, Map<String, Object>> costPriceResult = new HashMap(16);
        try {
            costPriceResult = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getPrice4ExtSys", (Object[])new Object[]{"J", allParams});
        }
        catch (Exception e) {
            String erroInfo = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6838\u7b97\u6210\u672c\u4ef7\u53d6\u4ef7\u670d\u52a1\u5f02\u5e38\uff1a%s\u3002", (String)"MaterialReqOutQueryPriceOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.info("MaterialReqOutQueryPriceOp\u9519\u8bef\u4fe1\u606f:" + erroInfo);
            throw new KDBizException(erroInfo);
        }
        logger.info("MaterialReqOutQueryPriceOp\u53d6\u4ef7\u67e5\u8be2\u53c2\u6570:" + allParams);
        return costPriceResult;
    }

    private Map<Long, Map<String, Object>> buildPriceParam(DynamicObject[] bills) {
        MainEntityType entityType = (MainEntityType)bills[0].getDataEntityType();
        HashSet<String> entities = new HashSet<String>();
        String entityTypeStr = entityType.getName();
        entities.add(entityTypeStr);
        Map resultMapping = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getBillFields", (Object[])new Object[]{entities});
        if (resultMapping == null || resultMapping.size() == 0) {
            String failReason = ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u914d\u7f6e\u201c\u6838\u7b97\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u201d\uff0c\u65e0\u6cd5\u8fdb\u884c\u4ef7\u683c\u67e5\u8be2\u3002", (String)"MaterialReqOutQueryPriceOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(failReason, entityType.getDisplayName()));
        }
        Map fieldMap = (Map)resultMapping.get(entityTypeStr);
        HashMap<String, String> headMap = new HashMap<String, String>(fieldMap.size());
        HashMap<String, String> entryMap = new HashMap<String, String>(fieldMap.size());
        for (Map.Entry fieldKeys : fieldMap.entrySet()) {
            String parentKey;
            String costFieldKey = (String)fieldKeys.getKey();
            String billFieldKey = (String)fieldKeys.getValue();
            IDataEntityProperty findProperty = entityType.findProperty(billFieldKey);
            if (findProperty == null || StringUtils.isEmpty((CharSequence)(parentKey = findProperty.getParent().getName()))) continue;
            if (parentKey.equals(entityTypeStr)) {
                headMap.put(costFieldKey, billFieldKey);
                continue;
            }
            if (!parentKey.equals("billentry")) continue;
            entryMap.put(costFieldKey, billFieldKey);
        }
        HashMap<Long, Map<String, Object>> allParams = new HashMap<Long, Map<String, Object>>(16);
        for (DynamicObject bill : bills) {
            Map<String, Object> pricingHeadParam = MaterialReqOutQueryPriceOp.getPricingParam(bill, headMap);
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                Long entryId = entry.getLong("id");
                HashMap<String, Object> pricingParam = new HashMap<String, Object>(2);
                pricingParam.putAll(pricingHeadParam);
                pricingParam.putAll(MaterialReqOutQueryPriceOp.getPricingParam(entry, entryMap));
                if (pricingParam.size() == 0) continue;
                pricingParam.put("entityobject", entityTypeStr);
                allParams.put(entryId, pricingParam);
            }
        }
        return allParams;
    }

    private static Map<String, Object> getPricingParam(DynamicObject bill, Map<String, String> billKeyMap) {
        if (billKeyMap == null || billKeyMap.size() == 0) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(billKeyMap.size());
        for (Map.Entry<String, String> headMap : billKeyMap.entrySet()) {
            String key = headMap.getKey();
            Object value = bill.get(headMap.getValue());
            if (value instanceof DynamicObject) {
                DynamicObject dynaobject = (DynamicObject)value;
                if ("bd_materialinventoryinfo".equals(dynaobject.getDataEntityType().getName())) {
                    dynaobject = dynaobject.getDynamicObject("masterid");
                }
                value = dynaobject.getLong("id");
            }
            paramMap.put(key, value);
        }
        return paramMap;
    }

    private void cachePricingInfo(DynamicObject[] bills) {
        this.cacheMap = new HashMap<Long, Map<String, Object>>(bills.length);
        for (DynamicObject bill : bills) {
            HashMap<String, Comparable<Date>> exRateMap = new HashMap<String, Comparable<Date>>(8);
            Long billId = bill.getLong("id");
            Date exRateDate = bill.getDate("biztime");
            DynamicObject targetCurrency = bill.getDynamicObject("settlecurrency");
            DynamicObject org = bill.getDynamicObject("org");
            Long orgId = org.getLong("id");
            Map currencyAndExRateTable = CurrencyHelper.getCurrencyAndExRateTableCache((Long)orgId);
            Long exchangeRateTableID = (Long)currencyAndExRateTable.get("exchangeRateTableID");
            exRateMap.put("exRateDate", exRateDate);
            exRateMap.put("targetCurrency", Long.valueOf(targetCurrency.getLong("id")));
            exRateMap.put("precision", Integer.valueOf(targetCurrency.getInt("amtprecision")));
            exRateMap.put("exchangeRateTableID", exchangeRateTableID);
            this.cacheMap.put(billId, exRateMap);
        }
    }
}

