/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.outbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SaleOutBillAuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(SaleOutBillAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("settlecurrency");
        e.getFieldKeys().add("entrysettleorg");
        e.getFieldKeys().add("remainreturnqty");
        e.getFieldKeys().add("remainreturnbaseqty");
        e.getFieldKeys().add("remainjoinpriceqty");
        e.getFieldKeys().add("remainjoinpricebaseqty");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("joinpriceqty");
        e.getFieldKeys().add("joinpricebaseqty");
        e.getFieldKeys().add("verifyqty");
        e.getFieldKeys().add("verifybaseqty");
        e.getFieldKeys().add("unverifyqty");
        e.getFieldKeys().add("unverifybaseqty");
        e.getFieldKeys().add("entrustverifyqty");
        e.getFieldKeys().add("entrustverifybaseqty");
        e.getFieldKeys().add("entrustunverifyqty");
        e.getFieldKeys().add("entrustunverifybaseqty");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("isinitbill");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"PurInBillAuditOp", (String)"beginOperationTransaction");){
            super.beginOperationTransaction(e);
            DynamicObject[] bills = e.getDataEntities();
            this.setRwFields(bills);
        }
    }

    private void setRwFields(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            boolean isUpdate = this.isUpdateWarehouse(bill);
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entryList) {
                if (!isUpdate) continue;
                this.updateWarehouse(entry);
            }
        }
    }

    private void updateWarehouse(DynamicObject entry) {
        DynamicObject wareHouse = entry.getDynamicObject("warehouse");
        if (wareHouse == null) {
            return;
        }
        DynamicObject location = entry.getDynamicObject("location");
        DynamicObject outWareHouse = entry.getDynamicObject("inwarehouse");
        if (outWareHouse == null) {
            entry.set("inwarehouse", (Object)wareHouse);
            entry.set("inlocation", (Object)location);
        }
    }

    private boolean isUpdateWarehouse(DynamicObject bill) {
        DynamicObject invScheme = bill.getDynamicObject("invscheme");
        if (invScheme == null) {
            return false;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        return isInUpdate && isOutUpdate;
    }
}

