/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.recbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.InspectionHelper;
import kd.scmc.im.business.helper.InvCheckRecInBillMatBaseQtyHelper;
import kd.scmc.im.business.helper.InvoiceBizHelper;

public class PurRecBillSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String[] SUPPLIERKEYS = new String[]{"invoicesupplier", "receivesupplier", "providersupplier"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billentry");
        keys.add("baseqty");
        keys.add("qty");
        keys.add("remaininvbaseqty");
        keys.add("remaininvqty");
        keys.add("curamountandtax");
        keys.add("purchasedqty");
        keys.add("remainpurqty");
        keys.add("purchasedamount");
        keys.add("remainpuramount");
        keys.add("remainjoinpriceqty");
        keys.add("remainjoinpricebaseqty");
        keys.add("joinpriceqty");
        keys.add("joinpricebaseqty");
        keys.add("verifyqty");
        keys.add("verifybaseqty");
        keys.add("unverifyqty");
        keys.add("unverifybaseqty");
        keys.add("totalreturnqty");
        keys.add("totalreturnbaseqty");
        keys.add("remainreturnqty");
        keys.add("remainreturnbaseqty");
        keys.add("isinspect");
        keys.add("emrelease");
        keys.add("totalinspqty");
        keys.add("totalinspbaseqty");
        keys.add("leftinspqty");
        keys.add("leftinspbaseqty");
        keys.add("totalunqualreturnqty");
        keys.add("totalunqualreturnbaseqty");
        keys.add("leftunqualreturnqty");
        keys.add("leftunqualreturnbaseqty");
        keys.add("concessionqty");
        keys.add("concessionbaseqty");
        keys.add("insporg");
        keys.add("materialmasterid");
        keys.add("invoicesupplier");
        keys.add("receivesupplier");
        keys.add("providersupplier");
        keys.add("invoicebiztype");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        InspectionHelper.checkNeedInspect((DynamicObject[])bills);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.beginOperationTransaction(e);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            Object supplier = bill.get("supplier");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                this.setEntrySupplier(entry, supplier == null ? null : (DynamicObject)supplier, SUPPLIERKEYS);
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal amount = entry.getBigDecimal("curamountandtax");
                entry.set("purchasedamount", (Object)BigDecimal.ZERO);
                entry.set("remainpuramount", (Object)amount);
                BigDecimal qualQyt = BigDecimal.ZERO;
                BigDecimal qualBaseQyt = BigDecimal.ZERO;
                BigDecimal leftInspQty = qty;
                BigDecimal leftInspBaseQty = baseQty;
                Boolean emRelease = entry.getBoolean("emrelease");
                Boolean isInsp = entry.getBoolean("isinspect");
                if (!isInsp.booleanValue() || emRelease.booleanValue()) {
                    qualQyt = qty;
                    qualBaseQyt = baseQty;
                    leftInspQty = BigDecimal.ZERO;
                    leftInspBaseQty = BigDecimal.ZERO;
                }
                this.batchSetValue(entry, BigDecimal.ZERO, "totalinspqty", "totalinspbaseqty", "totalreturnqty", "totalreturnbaseqty", "totalunqualreturnqty", "totalunqualreturnbaseqty", "invqty", "invbaseqty", "joinpriceqty", "joinpricebaseqty", "verifyqty", "unverifyqty", "purchasedqty", "leftunqualreturnqty", "leftunqualreturnbaseqty", "unqualifiedqty", "unqualifiedbaseqty", "totalreturnqty", "totalreturnbaseqty");
                this.batchSetValue(entry, leftInspQty, "leftinspqty");
                this.batchSetValue(entry, leftInspBaseQty, "leftinspbaseqty");
                this.batchSetValue(entry, qualQyt, "qualifiedqty", "remainreturnqty", "remaininvqty");
                this.batchSetValue(entry, qualBaseQyt, "qualifiedbaseqty", "remainreturnbaseqty", "remaininvbaseqty");
                this.batchSetValue(entry, qty, "remainjoinpriceqty", "unverifyqty", "remainpurqty");
                this.batchSetValue(entry, baseQty, "remainjoinpricebaseqty", "unverifybaseqty");
            }
            String appId = this.billEntityType.getAppId();
            InvoiceBizHelper.handleInvoiceBizNull((DynamicObject)bill, (String)appId);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"PurRecBillSubmitOp", (String)"endOperationTransaction");){
            super.endOperationTransaction(e);
            DynamicObject[] bills = e.getDataEntities();
            InvCheckRecInBillMatBaseQtyHelper.checkBaseQtyList((DynamicObject[])bills, (String)e.getOperationKey());
        }
    }

    private void batchSetValue(DynamicObject entry, Object value, String ... fields) {
        for (String field : fields) {
            entry.set(field, value);
        }
    }

    private void setEntrySupplier(DynamicObject entry, DynamicObject supplier, String[] fieldKeys) {
        if (supplier == null) {
            return;
        }
        for (String fieldKey : fieldKeys) {
            Object value = entry.get(fieldKey);
            if (value != null) continue;
            entry.set(fieldKey, (Object)supplier);
        }
    }
}

