/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.setup;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.WarehouseSetupHelper;
import kd.scmc.im.validator.setup.WarehouseSetupMaterialRelValidator;

public class WarehouseSetupMaterialRelSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("org");
        keys.add("warehouse");
        keys.add("materialnumber");
        keys.add("materialgrpnumber");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new WarehouseSetupMaterialRelValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] entities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : entities = e.getDataEntities()) {
            DynamicObject setUp = dataEntity.getDynamicObject("warehousesetup");
            if (setUp == null) {
                this.doAddNew(dataEntity);
                continue;
            }
            this.doEdit(dataEntity);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] entities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : entities = e.getDataEntities()) {
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject warehouse = dataEntity.getDynamicObject("warehouse");
            if (org == null || warehouse == null) continue;
            QFilter qFilter = new QFilter("org", "=", org.getPkValue()).and("warehouse", "=", warehouse.getPkValue());
            DynamicObject warehouseSetup = BusinessDataServiceHelper.loadSingle((String)"im_warehousesetup", (QFilter[])qFilter.toArray());
            Map materialEntryMap = WarehouseSetupHelper.loadMaterialEntryMap((Collection)Stream.of(new DynamicObject[]{warehouseSetup}).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            WarehouseSetupHelper.syncDefaultWarehouse((DynamicObject[])new DynamicObject[]{warehouseSetup}, (Map)materialEntryMap, (boolean)true);
        }
    }

    private void doEdit(DynamicObject dataEntity) {
        Object pkValue = dataEntity.getPkValue();
        DynamicObject setUpId = dataEntity.getDynamicObject("warehousesetup");
        if (setUpId != null) {
            DynamicObject setUp = BusinessDataServiceHelper.loadSingle((Object)setUpId.getPkValue(), (String)"im_warehousesetup");
            DynamicObjectCollection materialEntryEntity = setUp.getDynamicObjectCollection("materialentity");
            for (DynamicObject entry : materialEntryEntity) {
                Object id = entry.getPkValue();
                if (!pkValue.equals(id)) continue;
                this.buildMaterialEntryObj(dataEntity, entry.getInt("seq"));
                dataEntity.set("warehousesetup", (Object)setUp);
                return;
            }
        }
    }

    private void doAddNew(DynamicObject dataEntity) {
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject warehouse = dataEntity.getDynamicObject("warehouse");
        if (org != null && warehouse != null) {
            QFilter qFilter = new QFilter("org", "=", org.getPkValue()).and("warehouse", "=", warehouse.getPkValue());
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_warehousesetup", (String)"id, materialentity.seq", (QFilter[])qFilter.toArray(), (String)"materialentity.seq desc", (int)1);){
                if (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    Integer seq = next.getInteger("materialentity.seq");
                    this.addNewMaterialEntry(seq + 1, dataEntity);
                    Long pkValue = next.getLong("id");
                    DynamicObject setUp = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"im_warehousesetup");
                    dataEntity.set("warehousesetup", (Object)setUp);
                }
            }
        }
    }

    private void addNewMaterialEntry(Integer seq, DynamicObject dataEntity) {
        this.buildMaterialEntryObj(dataEntity, seq);
    }

    private DynamicObject buildMaterialEntryObj(DynamicObject newMaterialEntry, DynamicObject dataEntity, int seq) {
        DynamicObject materialInfo = dataEntity.getDynamicObject("materialnumber");
        if (materialInfo != null) {
            newMaterialEntry.set("materialmasterid", materialInfo.get("masterid"));
        }
        newMaterialEntry.set("seq", (Object)seq);
        newMaterialEntry.set("materialgrpnumber", (Object)dataEntity.getDynamicObject("materialgrpnumber"));
        newMaterialEntry.set("materialnumber", (Object)dataEntity.getDynamicObject("materialnumber"));
        return newMaterialEntry;
    }

    private DynamicObject buildMaterialEntryObj(DynamicObject dataEntity, int seq) {
        DynamicObject materialInfo = dataEntity.getDynamicObject("materialnumber");
        if (materialInfo != null) {
            dataEntity.set("materialmasterid", materialInfo.get("masterid"));
        }
        dataEntity.set("seqfield", (Object)seq);
        return dataEntity;
    }
}

