/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.setup;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.business.helper.WarehouseSetupHelper;
import kd.scmc.im.validator.setup.WarehouseSetupValidator;

public class WarehouseSetupSaveOp
extends AbstractOperationServicePlugIn {
    private Map<Long, Map<String, Long>> materialEntryMap = null;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("operatoruser");
        keys.add("materialnumber");
        keys.add("materialgrpnumber");
        keys.add("seq");
        keys.add("materialnumber");
        keys.add("materialmasterid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new WarehouseSetupValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        Object[] entities = e.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])entities)) {
            return;
        }
        this.materialEntryMap = WarehouseSetupHelper.loadMaterialEntryMap((Collection)Stream.of(entities).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] entities;
        super.beginOperationTransaction(e);
        for (DynamicObject warehouseSetup : entities = e.getDataEntities()) {
            DynamicObjectCollection materialEntitys = warehouseSetup.getDynamicObjectCollection("materialentity");
            for (DynamicObject materialEntity : materialEntitys) {
                DynamicObject materialInfo = materialEntity.getDynamicObject("materialnumber");
                if (materialInfo != null) {
                    materialEntity.set("materialmasterid", (Object)materialInfo.getDynamicObject("masterid"));
                    continue;
                }
                materialEntity.set("materialmasterid", null);
            }
        }
        WarehouseSetupHelper.syncDefaultWarehouse((DynamicObject[])entities, this.materialEntryMap, (boolean)true);
    }
}

