/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.setup;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.validator.setup.WarehouseSetupStopUseValidator;

public class WarehouseSetupStopUseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("startdate");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("startstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new WarehouseSetupStopUseValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operateKey = e.getOperationKey();
        if ("unsetup".equals(operateKey)) {
            List validDataEntityList = e.getValidExtDataEntities();
            for (ExtendedDataEntity extendedDataEntity : validDataEntityList) {
                extendedDataEntity.getDataEntity().set("startdate", null);
                extendedDataEntity.getDataEntity().set("startstatus", (Object)"A");
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateKey = e.getOperationKey();
        if ("unsetup".equals(operateKey)) {
            DynamicObject[] validDataEntityList = e.getDataEntities();
            QFilter invBalanceAndCloseFilter = this.buildBillQFilter(validDataEntityList);
            if (invBalanceAndCloseFilter == null) {
                return;
            }
            DeleteServiceHelper.delete((String)"im_closeaccountrecord", (QFilter[])invBalanceAndCloseFilter.toArray());
            String entityInvbalance = "im_invbalance";
            if (BalanceUpdateHandle.isNewPeriodBal()) {
                entityInvbalance = "im_inv_periodbalance";
            }
            DeleteServiceHelper.delete((String)entityInvbalance, (QFilter[])invBalanceAndCloseFilter.toArray());
            SaveServiceHelper.save((DynamicObject[])validDataEntityList);
        }
    }

    private QFilter buildBillQFilter(DynamicObject[] validDataEntityList) {
        Long orgPkId = null;
        Long warehousePkId = null;
        QFilter billQFilter = null;
        QFilter orgWarehouseWFilter = null;
        for (DynamicObject orgWarehouseObj : validDataEntityList) {
            orgPkId = orgWarehouseObj.getDynamicObject("org").getLong("id");
            warehousePkId = orgWarehouseObj.getDynamicObject("warehouse").getLong("id");
            orgWarehouseWFilter = new QFilter("org", "=", (Object)orgPkId).and(new QFilter("warehouse", "=", (Object)warehousePkId));
            if (billQFilter == null) {
                billQFilter = orgWarehouseWFilter;
                continue;
            }
            billQFilter.or(orgWarehouseWFilter);
        }
        return billQFilter;
    }
}

