/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.SerialNumberHelper;
import kd.scmc.im.business.helper.acct.BalanceHelper;
import kd.scmc.im.consts.InvBalanceConst;
import kd.scmc.im.consts.InvBillConst;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.validator.plugin.BillTplBaseValidatorPlugin;

public final class BillTplAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BillTplAuditOp.class);
    private static final Set<String> USED_ASYNC_BILL = new HashSet<String>(13);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(InvBillConst.getSelectorListForAcc());
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("stockindate");
        e.getFieldKeys().add("logisticsbill");
        e.getFieldKeys().add("isvirtualbill");
        e.getFieldKeys().add("invtype");
        e.getFieldKeys().add("outinvtype");
        e.getFieldKeys().add("ininvtype");
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("billentry.seq");
        this.addMaterialReqOutField(e);
    }

    private void addMaterialReqOutField(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("settleorg");
        e.getFieldKeys().add("costcenterorg");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        BillTplBaseValidatorPlugin tplValidator = new BillTplBaseValidatorPlugin(e, "audit", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplAuditOp", (String)"beginOperationTransaction");){
            super.beginOperationTransaction(e);
            DynamicObject[] invBills = e.getDataEntities();
            if (invBills == null || invBills.length == 0) {
                return;
            }
            String entityName = this.billEntityType.getName();
            if (!USED_ASYNC_BILL.contains(entityName)) {
                this.callBalanceUpdate(invBills, entityName);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operate = (String)this.operateMeta.get("type");
        String formId = this.billEntityType.getName();
        TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
        triggerEventHelper.triggerEventByOp(e.getDataEntities(), operate, formId, this.getOption());
        String entityName = this.billEntityType.getName();
        if (!USED_ASYNC_BILL.contains(entityName)) {
            this.callSnService(e.getDataEntities());
        }
    }

    private void callBalanceUpdate(DynamicObject[] invBills, String formId) {
        try (TraceSpan span = Tracer.create((String)"BillTplAuditOp", (String)"callBalanceUpdate");){
            ArrayList<Long> pks = new ArrayList<Long>(invBills.length + 1);
            for (DynamicObject invBill : invBills) {
                pks.add(invBill.getLong("id"));
            }
            if (formId.equals("im_initbill")) {
                BalanceHelper.initBalanceUpdate((String)formId, pks);
            } else if (InvBalanceConst.getBalBillList().contains(formId)) {
                BalanceHelper.auditBalanceUpdate((String)formId, pks);
            }
        }
    }

    private void callSnService(DynamicObject[] bills) {
        if (bills == null || bills.length == 0) {
            return;
        }
        ArrayList<Long> hasSNBillIdList = new ArrayList<Long>(bills.length);
        String billType = bills[0].getDynamicObjectType().getName();
        for (DynamicObject bill : bills) {
            Long billid = (Long)bill.getPkValue();
            if (!SerialNumberHelper.isInvBillEnableSerial((DynamicObject)bill) || InvBillHelper.isVirtualBill((DynamicObject)bill) || InvBillHelper.isInitBill((DynamicObject)bill)) continue;
            hasSNBillIdList.add(billid);
        }
        if (hasSNBillIdList.isEmpty()) {
            return;
        }
        logger.debug("BillTplOp:\u6ce8\u518c\u5e8f\u5217\u53f7\u5904\u7406\u5206\u5e03\u5f0f\u4e8b\u52a1");
        ECGlobalSession.begin((String)"scm_bill_audit", (DBRoute)DBRoute.of((String)"scmc"), (Propagation)Propagation.REQUIRES_NEW);
        CommonParam param = new CommonParam();
        param.put((Object)"billtype", (Object)billType);
        param.put((Object)"operate", (Object)"audit");
        param.put((Object)"billIds", hasSNBillIdList);
        ECGlobalSession.register((String)"scmc", (String)"sbs", (String)"SerialNumberAuditECService", (Param)param, (String)"callSnService");
        ECGlobalSession.setBusinessType((String)"snService");
        ArrayList<String> businessInfoList = new ArrayList<String>(hasSNBillIdList.size());
        for (Long billId : hasSNBillIdList) {
            businessInfoList.add(billType + "#" + billId.toString());
        }
        ECGlobalSession.setBusinessInfo(businessInfoList);
        ECGlobalSession.setAsync((boolean)false);
    }

    static {
        USED_ASYNC_BILL.add("im_transdirbill");
        USED_ASYNC_BILL.add("im_materialreqoutbill");
        USED_ASYNC_BILL.add("im_productinbill");
        USED_ASYNC_BILL.add("im_purinbill");
        USED_ASYNC_BILL.add("im_purreceivebill");
        USED_ASYNC_BILL.add("im_saloutbill");
        USED_ASYNC_BILL.add("im_otherinbill");
        USED_ASYNC_BILL.add("im_otheroutbill");
        USED_ASYNC_BILL.add("im_transoutbill");
        USED_ASYNC_BILL.add("im_locationtransfer");
        USED_ASYNC_BILL.add("im_transinbill");
        USED_ASYNC_BILL.add("im_initbill");
        USED_ASYNC_BILL.add("im_mdc_mftproorder");
        USED_ASYNC_BILL.add("im_mdc_mftfeedorder");
        USED_ASYNC_BILL.add("im_mdc_mftreturnorder");
        USED_ASYNC_BILL.add("im_mdc_mftmanuinbill");
        USED_ASYNC_BILL.add("im_mdc_mftreturnbill");
        USED_ASYNC_BILL.add("im_mdc_omcmplinbill");
        USED_ASYNC_BILL.add("im_mdc_omfeedbill");
        USED_ASYNC_BILL.add("im_mdc_omoutbill");
        USED_ASYNC_BILL.add("im_mdc_omreturnbill");
    }
}

