/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.errorcode.InvBaseErrorCode;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.validator.plugin.BillTplBaseValidatorPlugin;
import kd.scmc.im.validator.tpl.SerialNumberSaveValidator;

public final class BillTplDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("stockindate");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("isvirtualbill");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SerialNumberSaveValidator());
        BillTplBaseValidatorPlugin tplValidator = new BillTplBaseValidatorPlugin(e, "delete", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplDeleteOp", (String)"endOperationTransaction");){
            DynamicObject[] invBills = e.getDataEntities();
            if (invBills == null) {
                throw new KDBizException(InvBaseErrorCode.getBILL_NOT_EXISTS(), new Object[0]);
            }
            String operate = (String)this.operateMeta.get("type");
            String formId = this.billEntityType.getName();
            TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
            triggerEventHelper.triggerEventByOp(invBills, operate, formId, this.getOption());
        }
    }
}

