/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.consts.InvBillConst;
import kd.scmc.im.validator.improt.BillTplImportHandle;
import kd.scmc.im.validator.improt.ImportHandleUnit;
import kd.scmc.im.validator.integration.EASIntegrationUnit;
import kd.scmc.im.validator.plugin.BillTplBaseValidatorPlugin;

public final class BillTplSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        InvBillConst.getSelectorListForAcc().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("stockindate");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("materialmasterid");
        e.getFieldKeys().add("srcsystem");
        String formId = this.billEntityType.getName();
        if ("im_purreceivebill".equals(formId) || "im_purinbill".equals(formId) || "im_ospurinbill".equals(formId)) {
            e.getFieldKeys().add("supplier");
            e.getFieldKeys().add("providersupplier");
            e.getFieldKeys().add("invoicesupplier");
            e.getFieldKeys().add("receivesupplier");
        }
        if ("im_saloutbill".equals(formId)) {
            e.getFieldKeys().add("customer");
            e.getFieldKeys().add("settlecustomer");
            e.getFieldKeys().add("payingcustomer");
            e.getFieldKeys().add("reccustomer");
            e.getFieldKeys().add("inputamount");
        }
        if ("im_purinbill".equals(formId) || "im_ospurinbill".equals(formId)) {
            e.getFieldKeys().add("inputamount");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        BillTplBaseValidatorPlugin tplValidator = new BillTplBaseValidatorPlugin(e, "save", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplSaveOp", (String)"beginOperationTransaction");){
            BillTplImportHandle improtHandle;
            List<String> errorMsg;
            List<String> result;
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities.length == 0) {
                return;
            }
            MainEntityType dataEntityType = (MainEntityType)dataEntities[0].getDataEntityType();
            IDataEntityProperty bookDateProp = dataEntityType.findProperty("bookdate");
            ArrayList<DynamicObject> importData = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> integrationData = new ArrayList<DynamicObject>();
            boolean isBreakLastEdit = this.operateOption.containsVariable("breakLastEdit");
            for (DynamicObject dataEntity : dataEntities) {
                String billCreType;
                String srcsystem;
                DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
                if (billEntry != null && billEntry.size() != 0 && "EAS".equals(srcsystem = ((DynamicObject)dataEntity.getDynamicObjectCollection("billentry").get(0)).getString("srcsystem"))) {
                    integrationData.add(dataEntity);
                }
                if (bookDateProp != null) {
                    this.updateBookDate(dataEntity, bookDateProp);
                }
                if (!isBreakLastEdit) {
                    dataEntity.set("lastupdateuser", (Object)UserServiceHelper.getCurrentUser((String)"id"));
                    dataEntity.set("lastupdatetime", (Object)new Date());
                }
                if (!"1".equals(billCreType = dataEntity.getString("billcretype")) && !"3".equals(billCreType)) continue;
                importData.add(dataEntity);
            }
            if (!integrationData.isEmpty() && !(result = EASIntegrationUnit.handle(integrationData)).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String err : result) {
                    sb.append(err).append("\r\n");
                }
                throw new KDBizException(sb.toString());
            }
            if (!importData.isEmpty() && !(errorMsg = (improtHandle = ImportHandleUnit.getImportHandle(importData)).getErrorMsg()).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String err : errorMsg) {
                    sb.append(err).append("\r\n");
                }
                throw new KDBizException(sb.toString());
            }
        }
    }

    private void updateBookDate(DynamicObject data, IDataEntityProperty bookDateProp) {
        Date bookDate = data.getDate(bookDateProp);
        if (bookDate == null) {
            data.set("bookdate", (Object)data.getDate("biztime"));
        }
    }
}

