/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.scmc.im.business.helper.BizGroupRecordHelper;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.validator.plugin.BillTplBaseValidatorPlugin;

public final class BillTplUnSubmitOp
extends AbstractOperationServicePlugIn {
    private static List<String> verifyFields = Arrays.asList("warehouse", "stockindate", "billentry.seq", "material", "logisticsbill");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(verifyFields);
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("biztime");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("owner");
        e.getFieldKeys().add("ownertype");
        e.getFieldKeys().add("outowner");
        e.getFieldKeys().add("outownertype");
        e.getFieldKeys().add("outwarehouse");
        e.getFieldKeys().add("isvirtualbill");
        e.getFieldKeys().add("invscheme");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        BillTplBaseValidatorPlugin tplValidator = new BillTplBaseValidatorPlugin(e, "unsubmit", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operate = (String)this.operateMeta.get("type");
        String formId = this.billEntityType.getName();
        TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
        triggerEventHelper.triggerEventByOp(e.getDataEntities(), operate, formId, this.getOption());
        if (BizGroupRecordHelper.isBizGroupModel()) {
            DynamicObject[] invBills = e.getDataEntities();
            HashSet<Long> invBillIds = new HashSet<Long>(16);
            for (DynamicObject invBill : invBills) {
                Long id = invBill.getLong("id");
                invBillIds.add(id);
            }
            BizGroupRecordHelper.deleteRecord(invBillIds, (String)formId, (boolean)true);
        }
    }
}

