/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.InverseBillHelper;
import kd.scmc.im.consts.InvSchemeConst;

public class InvBillInverseBillOp
extends AbstractOperationServicePlugIn {
    protected String[] getNeedInverseColumns() {
        String billEntity = this.billEntityType.getName();
        String[] needInverseColumns = InverseBillHelper.getNeedInverseColumns((String)billEntity);
        return needInverseColumns;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String[] needInverseColumns = this.getNeedInverseColumns();
        if (needInverseColumns != null && needInverseColumns.length > 0) {
            e.getFieldKeys().addAll(Arrays.asList(needInverseColumns));
        }
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("ischargeoff");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        try (TraceSpan span = Tracer.create((String)"InvBillInverseBillOp", (String)"beforeExecuteOperationTransaction");){
            DynamicObject[] datas = e.getDataEntities();
            String[] needInverseColumns = this.getNeedInverseColumns();
            if (needInverseColumns != null && needInverseColumns.length > 0) {
                for (DynamicObject order : datas) {
                    boolean result;
                    boolean negativeBill = this.isNegativeBill(order);
                    boolean caBill = order.getBoolean("ischargeoff");
                    boolean bl = caBill ? !negativeBill : (result = negativeBill);
                    if (!result) continue;
                    DynamicObjectCollection entrys = order.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : entrys) {
                        for (String column : needInverseColumns) {
                            BigDecimal value = entry.getBigDecimal(column);
                            if (value == null) {
                                value = BigDecimal.ZERO;
                            }
                            value = value.abs().negate();
                            entry.set(column, (Object)value);
                        }
                    }
                }
            }
        }
    }

    private boolean isNegativeBill(DynamicObject order) {
        DynamicObject invscheme = order.getDynamicObject("invscheme");
        if (invscheme == null) {
            return false;
        }
        boolean isNegativeBill = false;
        DynamicObject transceiverType = (invscheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invscheme.getPkValue(), (String)"im_invscheme", (String)InvSchemeConst.getAllSelector())).getDynamicObject("transceivertype");
        String bizdirection = transceiverType.getString("bizdirection");
        if ("1".equals(bizdirection)) {
            isNegativeBill = true;
        }
        return isNegativeBill;
    }
}

