/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.opplugin.tpl.BillTplImportOp;

public class MaterialReqOutBillImportOp
extends BillTplImportOp {
    @Override
    protected void initBill2Qty(Map<String, Object> data, List<Map<String, Object>> listData, ImportLogger logger) {
        super.initBill2Qty(data, listData, logger);
        if (listData == null) {
            return;
        }
        for (Map<String, Object> entry : listData) {
            BigDecimal qty = this.convert2BigDecimal(entry.get("qty"));
            BigDecimal baseqty = this.convert2BigDecimal(entry.get("baseqty"));
            entry.put("outqty", 0);
            entry.put("outbaseqty", 0);
            entry.put("remainoutqty", qty);
            entry.put("remainoutbaseqty", baseqty);
        }
    }

    @Override
    protected void handleRowData(ImportLogger logger, Iterator<ImportBillData> iterator) {
        super.handleRowData(logger, iterator);
    }

    @Override
    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeImportBill(rowdatas, logger);
        this.handleProduct(rowdatas, logger);
        String manageName = ResManager.loadKDString((String)"\u5e93\u7ba1\u5458", (String)"MaterialReqOutBillImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        String manageGroupName = ResManager.loadKDString((String)"\u5e93\u7ba1\u7ec4", (String)"MaterialReqOutBillImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        this.update4BizOperator(rowdatas, "operator", "operatorgroup", logger, manageName, manageGroupName);
    }

    private void handleProduct(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData rowdata = iterator.next();
            int index = rowdata.getStartIndex();
            JSONObject data = rowdata.getData();
            String billno = (String)data.get((Object)"billno");
            Map orgMap = (Map)data.get((Object)"org");
            if (orgMap == null) continue;
            String orgNum = (String)orgMap.get("number");
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNum)});
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)((Long)org.getPkValue()));
            List listData = (List)data.get((Object)"billentry");
            if (listData == null) continue;
            ArrayList logInfoList = new ArrayList(listData.size());
            for (Map map : listData) {
                Map product = (Map)map.get("product");
                if (product == null) {
                    ++index;
                    continue;
                }
                String productNum = (String)product.get("number");
                QFilter qFilter = new QFilter("number", "=", (Object)productNum);
                qFilter.and(baseDataFilter);
                DynamicObject productDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])qFilter.toArray());
                if (null == productDyn) {
                    ++index;
                    continue;
                }
                Boolean enableproduct = productDyn.getBoolean("enableproduct");
                Boolean enableoutsource = productDyn.getBoolean("enableoutsource");
                if (!enableproduct.booleanValue() && !enableoutsource.booleanValue()) {
                    HashMap<String, Object> logInfo = new HashMap<String, Object>(2);
                    logInfo.put("index", index);
                    logInfo.put("productNum", productNum);
                    logInfoList.add(logInfo);
                }
                ++index;
            }
            if (logInfoList.isEmpty()) continue;
            for (Map map : logInfoList) {
                logger.log((Integer)map.get("index"), String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1s\u201d\u7684\u4ea7\u54c1\u201c%2s\u201d\u5fc5\u987b\u53ef\u751f\u4ea7\u6216\u53ef\u59d4\u5916\u3002", (String)"MaterialReqOutBillImportOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), billno, map.get("productNum")));
            }
            logger.fail();
            iterator.remove();
        }
    }

    @Override
    protected void initHeadData(JSONObject data) {
        super.initHeadData(data);
        Object supplierOwnerType = data.get((Object)"supplyownertype");
        if (!"bd_supplier".equals(supplierOwnerType)) {
            data.put("supplyownertype", (Object)"bos_org");
        }
    }

    @Override
    protected void cacheBaseData(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.cacheBizOperatorData(rowdatas, new String[]{"operator"}, new String[]{"operatorgroup"});
    }
}

