/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.LineTypeHelper;
import kd.scmc.im.opplugin.tpl.BillTplImportOp;

public class TransDirImportOp
extends BillTplImportOp {
    private Map<String, Map<String, DynamicObject>> materialDymOrgMap = new HashMap<String, Map<String, DynamicObject>>();
    private Map<String, Map<DynamicObject, QFilter>> orgAndBaseFilter = new HashMap<String, Map<DynamicObject, QFilter>>();
    private Map<String, DynamicObject> bizTypeMap = new HashMap<String, DynamicObject>();

    @Override
    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            this.handleRow(logger, iterator);
        }
        String manageName = ResManager.loadKDString((String)"\u5e93\u7ba1\u5458", (String)"TransDirImportOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        String manageGroupName = ResManager.loadKDString((String)"\u5e93\u7ba1\u7ec4", (String)"TransDirImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        this.update4BizOperator(rowdatas, "operator", "operatorgroup", logger, manageName, manageGroupName);
        this.update4BizOperator(rowdatas, "outoperator", "outoperatorgroup", logger, manageName, manageGroupName);
    }

    private void handleRow(ImportLogger logger, Iterator<ImportBillData> iterator) {
        ImportBillData rowdata = iterator.next();
        int index = rowdata.getStartIndex();
        JSONObject data = rowdata.getData();
        this.initHeadData(data);
        Map orgMap = (Map)data.get((Object)"org");
        if (orgMap == null) {
            return;
        }
        String orgNum = (String)orgMap.get("number");
        if (StringUtils.isBlank((CharSequence)orgNum)) {
            return;
        }
        Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(orgNum);
        if (materialDymMap == null) {
            return;
        }
        List listData = (List)data.get((Object)"billentry");
        for (Map row : listData) {
            Map importLineTypeMap = (Map)row.get("linetype");
            if (importLineTypeMap != null) {
                return;
            }
            Map importBizTypeMap = (Map)data.get((Object)"biztype");
            DynamicObject bizType = this.bizTypeMap.get(importBizTypeMap.get("number"));
            if (bizType == null) {
                return;
            }
            DynamicObject lineType = LineTypeHelper.getLineTypeByBizType((DynamicObject)bizType);
            if (lineType == null) {
                return;
            }
            HashMap<String, String> lineTypeMap = new HashMap<String, String>(4);
            lineTypeMap.put("importprop", "number");
            lineTypeMap.put("number", lineType.getString("number"));
            lineTypeMap.put("name", lineType.getString("name"));
            row.put("linetype", JSONObject.toJSON(lineTypeMap));
            Map material = (Map)row.get("material");
            if (material == null) {
                return;
            }
            String materialNum = (String)material.get("number");
            DynamicObject materialDym = materialDymMap.get(materialNum);
            if (materialDym == null) {
                return;
            }
            boolean isdisposable = materialDym.getBoolean("masterid.isdisposable");
            if (isdisposable) continue;
            row.put("materialname", materialDym.getString("masterid.name"));
        }
        data.put("billentry", (Object)listData);
    }

    @Override
    protected void cacheBaseData(List<ImportBillData> rowdatas, ImportLogger logger) {
        HashMap<String, HashSet<String>> materialNumsMap = new HashMap<String, HashSet<String>>();
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            int index = rowdata.getStartIndex();
            Object bizTypeObj = data.get((Object)"biztype");
            if (bizTypeObj == null) {
                return;
            }
            DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_biztype", (QFilter[])new QFilter("number", "=", ((Map)bizTypeObj).get("number")).toArray());
            if (bizType == null) {
                return;
            }
            this.bizTypeMap.put(bizType.getString("number"), bizType);
            Map orgMap = (Map)data.get((Object)"org");
            Map outOrgMap = (Map)data.get((Object)"outorg");
            String billno = (String)data.get((Object)"billno");
            int failedTotal = logger.getFailed() + 1;
            if (orgMap == null) {
                logger.setFailed(failedTotal);
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u8c03\u5165\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"TransDirImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), billno)).fail();
                iterator.remove();
                continue;
            }
            if (outOrgMap == null) {
                logger.setFailed(failedTotal);
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u8c03\u51fa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransDirImportOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), billno)).fail();
                iterator.remove();
                continue;
            }
            String transtype = String.valueOf(data.get((Object)"transtype") == null ? "" : data.get((Object)"transtype"));
            String outOrgNum = String.valueOf(outOrgMap.get("number") == null ? "" : outOrgMap.get("number"));
            String orgNum = String.valueOf(orgMap.get("number"));
            if (StringUtils.isBlank((CharSequence)outOrgNum)) continue;
            if (StringUtils.isBlank((CharSequence)orgNum)) {
                if ("A".equals(transtype)) {
                    orgMap.put("number", outOrgNum);
                } else {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u8c03\u5165\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransDirImportOp_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), billno)).fail();
                    iterator.remove();
                    continue;
                }
            }
            Map<String, DynamicObject> materialCacheMap = this.materialDymOrgMap.get(outOrgNum);
            if (!this.orgAndBaseFilter.containsKey(outOrgNum)) {
                QFilter qFilter = new QFilter("number", "=", (Object)outOrgNum);
                qFilter.and(new QFilter("status", "=", (Object)"C"));
                qFilter.and(new QFilter("enable", "=", (Object)"1"));
                DynamicObject outOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])qFilter.toArray());
                if (outOrg == null) {
                    logger.setFailed(failedTotal);
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u8bf7\u7ed9\u5355\u636e\u201c%s\u201d\u8f93\u5165\u53ef\u7528\u7684\u8c03\u51fa\u7ec4\u7ec7\u3002", (String)"TransDirImportOp_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), billno)).fail();
                    iterator.remove();
                    continue;
                }
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)outOrg.getPkValue()));
                HashMap<DynamicObject, QFilter> orgAndFilter = new HashMap<DynamicObject, QFilter>();
                orgAndFilter.put(outOrg, baseDataFilter);
                this.orgAndBaseFilter.put(outOrgNum, orgAndFilter);
            }
            List listData = (List)data.get((Object)"billentry");
            for (Map row : listData) {
                Map material = (Map)row.get("material");
                if (material == null) continue;
                String materialNum = (String)material.get("number");
                if (materialCacheMap != null && materialCacheMap.containsKey(materialNum)) continue;
                HashSet<String> materialNums = (HashSet<String>)materialNumsMap.get(outOrgNum);
                if (materialNums == null) {
                    materialNums = new HashSet<String>();
                    materialNumsMap.put(outOrgNum, materialNums);
                }
                if (!materialNums.add(materialNum)) continue;
            }
        }
        if (materialNumsMap.size() > 0) {
            for (Map.Entry next : materialNumsMap.entrySet()) {
                String outOrgNum = (String)next.getKey();
                Set materialNums = (Set)next.getValue();
                Map<DynamicObject, QFilter> orgAndFilter = this.orgAndBaseFilter.get(outOrgNum);
                if (orgAndFilter == null) continue;
                QFilter baseDataFilter = orgAndFilter.values().iterator().next();
                Map materialDymLoad = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{new QFilter("masterid.number", "in", (Object)materialNums), baseDataFilter});
                for (DynamicObject materialDym : materialDymLoad.values()) {
                    Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(outOrgNum);
                    if (materialDymMap == null) {
                        materialDymMap = new HashMap<String, DynamicObject>();
                        this.materialDymOrgMap.put(outOrgNum, materialDymMap);
                    }
                    materialDymMap.put(materialDym.getString("masterid.number"), materialDym);
                }
            }
        }
        this.cacheBizOperatorData(rowdatas, new String[]{"operator"}, new String[]{"operatorgroup"});
        this.cacheBizOperatorData(rowdatas, new String[]{"outoperator"}, new String[]{"outoperatorgroup"});
    }
}

