/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.BizGroupRecordHelper;
import kd.scmc.im.utils.DateUtils;

public final class TransFormBillTplSubmitOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] invBills;
        super.beginOperationTransaction(e);
        for (DynamicObject invBill : invBills = e.getDataEntities()) {
            invBill.set("biztime", (Object)DateUtils.getDate((Date)invBill.getDate("biztime")));
            invBill.set("bookdate", (Object)DateUtils.getDate((Date)invBill.getDate("bookdate")));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"TransFormBillTplSubmitOp", (String)"endOperationTransaction");){
            DynamicObject[] invBills = e.getDataEntities();
            String formId = this.billEntityType.getName();
            if (BizGroupRecordHelper.isBizGroupModel()) {
                HashSet<Long> invBillIds = new HashSet<Long>(16);
                for (DynamicObject invBill : invBills) {
                    Long id = invBill.getLong("id");
                    invBillIds.add(id);
                }
                BizGroupRecordHelper.createRecord(invBillIds, (String)formId, (boolean)true);
            }
        }
    }
}

