/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.transbill;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.mservice.ShardingMetadataService;
import kd.scmc.im.business.helper.TransInIsOverHelper;

public class TransApplyCloseOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(TransApplyCloseOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("rowbillstatus");
        fieldKeys.add("biztime");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.invokeCalService(dataEntities);
    }

    private void invokeCalService(DynamicObject[] dataEntities) {
        if (ECServiceSwitch.isOpened()) {
            return;
        }
        Map<String, Object> overTrans = this.overTrans(dataEntities);
        if (overTrans == null) {
            return;
        }
        Map entryIdOverTransMap = (Map)overTrans.get("entryIdOverTransMap");
        Set transInBillIds = (Set)overTrans.get("billIds");
        if (entryIdOverTransMap == null || transInBillIds == null) {
            return;
        }
        logger.info("TransApplyCloseOp:beforeExecuteOperationTransaction\u8c03\u62e8\u5b8c\u6210:\u5f00\u59cb\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u670d\u52a1:" + StringUtils.join((Object[])entryIdOverTransMap.keySet().toArray(), (String)",") + StringUtils.join((Object[])entryIdOverTransMap.values().toArray(), (String)","));
        HashSet trueEntryIds = new HashSet(entryIdOverTransMap.size());
        HashSet falseEntryIds = new HashSet(entryIdOverTransMap.size());
        for (Map.Entry item : entryIdOverTransMap.entrySet()) {
            if (((Boolean)item.getValue()).booleanValue()) {
                trueEntryIds.add(item.getKey());
                continue;
            }
            falseEntryIds.add(item.getKey());
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupCompletedService", (String)"batchDoService", (Object[])new Object[]{transInBillIds, trueEntryIds, falseEntryIds});
        logger.info("TransApplyCloseOp:beforeExecuteOperationTransaction\u8c03\u62e8\u5b8c\u6210:\u7ed3\u675f\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u670d\u52a1\uff1a");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.invokeCalServiceByEc(dataEntities);
    }

    private void invokeCalServiceByEc(DynamicObject[] dataEntities) {
        if (!ECServiceSwitch.isOpened()) {
            return;
        }
        Map<String, Object> overTrans = this.overTrans(dataEntities);
        if (overTrans == null) {
            return;
        }
        Map entryIdOverTransMap = (Map)overTrans.get("entryIdOverTransMap");
        if (entryIdOverTransMap == null) {
            return;
        }
        CommonParam commonParam = new CommonParam();
        commonParam.putAll(entryIdOverTransMap);
        ECServiceHelper.execute((String)"im_transapply_close", (String)"updateGroupRecord", (String)"fi", (String)"cal", (String)"CalGroupCompletedBatchDoService", (Param)commonParam);
    }

    private Map<String, Object> overTrans(DynamicObject[] dataEntities) {
        HashMap<String, Object> overTransMap = new HashMap<String, Object>();
        HashSet<Object> rowIds = new HashSet<Object>();
        Date bizTime = new Date();
        for (DynamicObject data : dataEntities) {
            Date date = data.getDate("biztime");
            if (bizTime.after(date)) {
                bizTime = date;
            }
            DynamicObjectCollection collection = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : collection) {
                rowIds.add(entry.getPkValue());
            }
        }
        if (rowIds.isEmpty()) {
            return null;
        }
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(rowIds.size());
        HashMap<Long, Boolean> entryIdOverTransMap = new HashMap<Long, Boolean>(rowIds.size());
        QFilter invSchemeFilter = TransInIsOverHelper.getTransInInvScheme();
        ShardingMetadataService shardingMetadataService = ShardingMetadataService.getInstance();
        boolean isXDBEnable = shardingMetadataService.isXDBEnableByEntity("im_transinbill");
        if (isXDBEnable) {
            invSchemeFilter.and("bookdate", ">=", (Object)bizTime);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"im_transinbill", (String)"id,auditdate,billentry.mainbillentryid,billentry.isovertrans", (QFilter[])invSchemeFilter.and(new QFilter("billentry.mainbillentryid", "in", rowIds)).toArray());
        HashSet<Long> transInBillIds = new HashSet<Long>(16);
        for (DynamicObject data : load) {
            transInBillIds.add((Long)data.getPkValue());
            DynamicObjectCollection billEntry = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                Long mainBillEntryId = entry.getLong("mainbillentryid");
                DynamicObject parent = (DynamicObject)entry.getParent();
                Date auditDate = parent.getDate("auditdate");
                if (!entryMap.containsKey(mainBillEntryId)) {
                    entryMap.put(mainBillEntryId, entry);
                    entryIdOverTransMap.put((Long)entry.getPkValue(), true);
                    continue;
                }
                DynamicObject oldEntry = (DynamicObject)entryMap.get(mainBillEntryId);
                DynamicObject oldParent = (DynamicObject)oldEntry.getParent();
                Date oldDate = oldParent.getDate("auditdate");
                if (oldDate == null || auditDate == null || auditDate.compareTo(oldDate) <= 0) continue;
                entryMap.put(mainBillEntryId, entry);
                entryIdOverTransMap.put((Long)entry.getPkValue(), true);
            }
        }
        if (!entryMap.isEmpty()) {
            entryMap.values().forEach(v -> v.set("isovertrans", (Object)true));
        }
        SaveServiceHelper.save((DynamicObject[])load);
        overTransMap.put("entryIdOverTransMap", entryIdOverTransMap);
        overTransMap.put("billIds", transInBillIds);
        return overTransMap;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        if (entities == null || entities.length == 0) {
            return;
        }
        for (DynamicObject bill : entities) {
            bill.set("billstatus", (Object)"D");
            DynamicObjectCollection dt = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : dt) {
                row.set("rowbillstatus", (Object)"D");
            }
        }
        SaveServiceHelper.save((DynamicObject[])entities);
    }
}

