/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.transbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.GlobalSessionType;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class TransDirBillUnAuditOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(TransDirBillUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("inorg");
        fields.add("transtype");
        fields.add("isfreegift");
        fields.add("warehouse");
        fields.add("location");
        fields.add("outinvstatus");
        fields.add("outinvtype");
        fields.add("project");
        fields.add("ownertype");
        fields.add("owner");
        fields.add("keepertype");
        fields.add("keeper");
        fields.add("outwarehouse");
        fields.add("mainbillentity");
        fields.add("mainbillid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.callSrmService(dataEntities);
    }

    private void callSrmService(DynamicObject[] dataEntities) {
        Set targetIdsSet;
        String srcBillType = this.billEntityType.getName();
        ArrayList<Long> sourceIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            long id = dataEntity.getLong("id");
            sourceIds.add(id);
        }
        if (sourceIds.isEmpty()) {
            return;
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)srcBillType, (Long[])sourceIds.toArray(new Long[0]));
        if (targetBills != null && !targetBills.isEmpty() && (targetIdsSet = (Set)targetBills.get("pur_moduledelivery")) != null && !targetIdsSet.isEmpty()) {
            List targetIds = targetIdsSet.stream().collect(Collectors.toList());
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("ids", targetIds);
            param.put("entityName", "pur_moduledelivery");
            logger.debug("im_transdirbill_unaudit:\u6ce8\u518c\u5206\u5e03\u5f0f\u4e8b\u52a1");
            ECGlobalSession.begin((String)"im_transdirbill_unaudit", (DBRoute)DBRoute.of((String)"scm"), (GlobalSessionType)GlobalSessionType.COMBINATION);
            CommonParam commonParam = new CommonParam();
            commonParam.put((Object)"param", param);
            ECGlobalSession.register((String)"scmc", (String)"im", (String)"TransDirUnAuditCallSrmService", (Param)commonParam, (String)"callSrmService");
            ECGlobalSession.setBusinessType((String)"deleteSrmBill");
            ArrayList<String> businessInfoList = new ArrayList<String>(sourceIds.size());
            for (Long billId : sourceIds) {
                businessInfoList.add(srcBillType + "#" + billId.toString());
            }
            ECGlobalSession.setBusinessInfo(businessInfoList);
            ECGlobalSession.setAsync((boolean)false);
        }
    }
}

