/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.transbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.validator.general.LocationMustInputValidator;
import org.apache.commons.lang3.StringUtils;

public class TransDirSubmitOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new LocationMustInputValidator("outwarehouse", "outlocation"));
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("outdept");
        e.getFieldKeys().add("outoperatorgroup");
        e.getFieldKeys().add("outoperator");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("inlotnumber");
        e.getFieldKeys().add("inlot");
        e.getFieldKeys().add("outwarehouse");
        e.getFieldKeys().add("outlocation");
        e.getFieldKeys().add("lotnumber");
        e.getFieldKeys().add("inlotnumber");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("remainreturnqty");
        e.getFieldKeys().add("remainreturnbaseqty");
        e.getFieldKeys().add("ecostcenter");
        e.getFieldKeys().add("inecostcenter");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (ExtendedDataEntity array : e.getValidExtDataEntities()) {
            DynamicObject entity = array.getDataEntity();
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("billentry");
            String transType = entity.getString("transtype");
            DynamicObject org = entity.getDynamicObject("org");
            BigDecimal baseQty = null;
            BigDecimal qty = null;
            for (DynamicObject row : entry) {
                String inLotNumber = row.getString("inlotnumber");
                DynamicObject materialInfo = row.getDynamicObject("material");
                if (StringUtils.isBlank((CharSequence)inLotNumber)) {
                    if ("B".equals(transType)) {
                        materialInfo = this.getMaterialInfoByOrg(org, materialInfo);
                    }
                    if (materialInfo == null || materialInfo.getBoolean("enablelot")) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u8c03\u5165\u6279\u53f7\u201d\u3002", (String)"TransDirSubmitOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                    }
                }
                this.lotNumValidator(row);
                qty = row.getBigDecimal("qty");
                baseQty = row.getBigDecimal("baseqty");
                row.set("returnqty", (Object)BigDecimal.ZERO);
                row.set("returnbaseqty", (Object)BigDecimal.ZERO);
                row.set("remainreturnqty", (Object)qty);
                row.set("remainreturnbaseqty", (Object)baseQty);
            }
        }
    }

    private DynamicObject getMaterialInfoByOrg(DynamicObject org, DynamicObject materialInfo) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
        DynamicObject[] materialinventory = BusinessDataServiceHelper.load((String)"bd_materialinventoryinfo", (String)"enablelot,ctrlstrategy", (QFilter[])new QFilter[]{new QFilter("masterid.id", "=", (Object)materialInfo.getLong("masterid.id")), baseDataFilter});
        if (materialinventory == null || materialinventory.length == 0) {
            return null;
        }
        DynamicObject inOrgMaterialInfo = materialinventory[0];
        String privateCtrlStrategy = "7";
        for (DynamicObject dynamicObject : materialinventory) {
            String ctrlStrategy = dynamicObject.getString("ctrlstrategy");
            if (!privateCtrlStrategy.equals(ctrlStrategy)) continue;
            inOrgMaterialInfo = dynamicObject;
            break;
        }
        return inOrgMaterialInfo;
    }

    private void lotNumValidator(DynamicObject row) {
        String lotNum = row.getString("lotnumber");
        String inlotNum = row.getString("inlotnumber");
        if (row.getBoolean("material.enablelot")) {
            lotNum = lotNum.replaceAll("\u3000", " ").trim();
            inlotNum = inlotNum.replaceAll("\u3000", " ").trim();
            if (!StringUtils.isEmpty((CharSequence)lotNum)) {
                row.set("lotnumber", (Object)lotNum);
            } else if (!StringUtils.isEmpty((CharSequence)inlotNum)) {
                row.set("inlotnumber", (Object)inlotNum);
            }
        }
    }
}

