/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.transbill;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.BizGroupRecordHelper;

public class TransInBillOverTransOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TransInBillOverTransOp.class);
    private static final String OVER_TRANS_KEY = "bar_overtrans";
    private static final String BILL_STATUS_C = "C";
    private static final String BILL_STATUS_B = "B";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        this.invokeCalService(operationKey, dataEntities);
    }

    private void invokeCalService(String operationKey, DynamicObject[] dataEntities) {
        if (ECServiceSwitch.isOpened()) {
            return;
        }
        Map<Long, Boolean> entryIdOverTransMap = this.overTrans(operationKey, dataEntities);
        if (entryIdOverTransMap == null) {
            return;
        }
        logger.info("TransInBillOverTransOp:beforeExecuteOperationTransaction\u8c03\u62e8\u5b8c\u6210:\u5f00\u59cb\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u670d\u52a1:" + StringUtils.join((Object[])entryIdOverTransMap.keySet().toArray(), (String)",") + StringUtils.join((Object[])entryIdOverTransMap.values().toArray(), (String)","));
        HashSet<Long> transInBillIds = new HashSet<Long>(1);
        transInBillIds.add((Long)dataEntities[0].getPkValue());
        HashSet<Long> trueEntryIds = new HashSet<Long>(entryIdOverTransMap.size());
        HashSet<Long> falseEntryIds = new HashSet<Long>(entryIdOverTransMap.size());
        for (Map.Entry<Long, Boolean> item : entryIdOverTransMap.entrySet()) {
            if (item.getValue().booleanValue()) {
                trueEntryIds.add(item.getKey());
                continue;
            }
            falseEntryIds.add(item.getKey());
        }
        if (BizGroupRecordHelper.isBizGroupModel()) {
            BizGroupRecordHelper.setBizGroupCompleted(transInBillIds, trueEntryIds, falseEntryIds);
        } else {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupCompletedService", (String)"batchDoService", (Object[])new Object[]{transInBillIds, trueEntryIds, falseEntryIds});
        }
        logger.info("TransInBillOverTransOp:beforeExecuteOperationTransaction\u8c03\u62e8\u5b8c\u6210:\u7ed3\u675f\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u670d\u52a1\uff1a");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        this.invokeCalServiceByEc(operationKey, dataEntities);
    }

    private void invokeCalServiceByEc(String operationKey, DynamicObject[] dataEntities) {
        if (!ECServiceSwitch.isOpened()) {
            return;
        }
        Map<Long, Boolean> entryIdOverTransMap = this.overTrans(operationKey, dataEntities);
        if (entryIdOverTransMap == null) {
            return;
        }
        CommonParam commonParam = new CommonParam();
        commonParam.putAll(entryIdOverTransMap);
        if (BizGroupRecordHelper.isBizGroupModel()) {
            HashSet<Long> transInBillIds = new HashSet<Long>(1);
            transInBillIds.add((Long)dataEntities[0].getPkValue());
            HashSet<Long> trueEntryIds = new HashSet<Long>(entryIdOverTransMap.size());
            HashSet<Long> falseEntryIds = new HashSet<Long>(entryIdOverTransMap.size());
            for (Map.Entry<Long, Boolean> item : entryIdOverTransMap.entrySet()) {
                if (item.getValue().booleanValue()) {
                    trueEntryIds.add(item.getKey());
                    continue;
                }
                falseEntryIds.add(item.getKey());
            }
            BizGroupRecordHelper.setBizGroupCompleted(transInBillIds, trueEntryIds, falseEntryIds);
        } else {
            ECServiceHelper.execute((String)"im_transinbill_overtrans", (String)"overTrans", (String)"fi", (String)"cal", (String)"CalGroupCompletedBatchDoService", (Param)commonParam);
        }
    }

    private Map<Long, Boolean> overTrans(String operationKey, DynamicObject[] dataEntities) {
        boolean billStatusFlag;
        DynamicObject transInBill = dataEntities[0];
        String billStatus = transInBill.getString("billstatus");
        boolean bl = billStatusFlag = !BILL_STATUS_C.equals(billStatus) && !BILL_STATUS_B.equals(billStatus);
        if (!OVER_TRANS_KEY.equals(operationKey) || billStatusFlag) {
            return null;
        }
        if (!this.isDataChange(transInBill)) {
            return null;
        }
        DynamicObjectCollection billEntry = transInBill.getDynamicObjectCollection("billentry");
        HashMap<Integer, Boolean> overTransMap = new HashMap<Integer, Boolean>(billEntry.size());
        HashMap<Long, Boolean> entryIdOverTransMap = new HashMap<Long, Boolean>(billEntry.size());
        for (DynamicObject entry : billEntry) {
            overTransMap.put(entry.getInt("seq"), entry.getBoolean("isovertrans"));
        }
        for (DynamicObject entry : billEntry) {
            entry.set("isovertrans", overTransMap.get(entry.getInt("seq")));
            entryIdOverTransMap.put((Long)entry.getPkValue(), (Boolean)overTransMap.get(entry.getInt("seq")));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transInBill});
        return entryIdOverTransMap;
    }

    private boolean isDataChange(DynamicObject transInBill) {
        Boolean isOverTrans;
        Long entryId;
        Object pkValue = transInBill.getPkValue();
        DynamicObject dbTransInBill = BusinessDataServiceHelper.loadSingle((String)"im_transinbill", (String)"isovertrans", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        DynamicObjectCollection dbBillEntry = dbTransInBill.getDynamicObjectCollection("billentry");
        DynamicObjectCollection billEntry = transInBill.getDynamicObjectCollection("billentry");
        HashMap<Long, Boolean> billEntryMap = new HashMap<Long, Boolean>(billEntry.size());
        HashMap<Long, Boolean> dbBillEntryMap = new HashMap<Long, Boolean>(dbBillEntry.size());
        for (DynamicObject entry : billEntry) {
            entryId = entry.getLong("id");
            isOverTrans = entry.getBoolean("isovertrans");
            billEntryMap.put(entryId, isOverTrans);
        }
        for (DynamicObject entry : dbBillEntry) {
            entryId = entry.getLong("id");
            isOverTrans = entry.getBoolean("isovertrans");
            dbBillEntryMap.put(entryId, isOverTrans);
        }
        for (Map.Entry entryMap : billEntryMap.entrySet()) {
            Boolean isOverTrans2;
            entryId = (Long)entryMap.getKey();
            Boolean dbIsOverTrans = (Boolean)dbBillEntryMap.get(entryId);
            if (dbIsOverTrans == null || dbIsOverTrans.equals(isOverTrans2 = (Boolean)entryMap.getValue())) continue;
            return true;
        }
        return false;
    }
}

